package zio.aws.databasemigration.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class SupportedEndpointType(
    engineName: Option[String] = None,
    supportsCDC: Option[Boolean] = None,
    endpointType: Option[
      zio.aws.databasemigration.model.ReplicationEndpointTypeValue
    ] = None,
    replicationInstanceEngineMinimumVersion: Option[String] = None,
    engineDisplayName: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.databasemigration.model.SupportedEndpointType = {
    import SupportedEndpointType.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.databasemigration.model.SupportedEndpointType
      .builder()
      .optionallyWith(engineName.map(value => value: java.lang.String))(
        _.engineName
      )
      .optionallyWith(supportsCDC.map(value => value: java.lang.Boolean))(
        _.supportsCDC
      )
      .optionallyWith(endpointType.map(value => value.unwrap))(_.endpointType)
      .optionallyWith(
        replicationInstanceEngineMinimumVersion.map(value =>
          value: java.lang.String
        )
      )(_.replicationInstanceEngineMinimumVersion)
      .optionallyWith(engineDisplayName.map(value => value: java.lang.String))(
        _.engineDisplayName
      )
      .build()
  }
  def asReadOnly
      : zio.aws.databasemigration.model.SupportedEndpointType.ReadOnly =
    zio.aws.databasemigration.model.SupportedEndpointType.wrap(buildAwsValue())
}
object SupportedEndpointType {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.databasemigration.model.SupportedEndpointType
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.databasemigration.model.SupportedEndpointType =
      zio.aws.databasemigration.model.SupportedEndpointType(
        engineName.map(value => value),
        supportsCDC.map(value => value),
        endpointType.map(value => value),
        replicationInstanceEngineMinimumVersion.map(value => value),
        engineDisplayName.map(value => value)
      )
    def engineName: Option[String]
    def supportsCDC: Option[Boolean]
    def endpointType
        : Option[zio.aws.databasemigration.model.ReplicationEndpointTypeValue]
    def replicationInstanceEngineMinimumVersion: Option[String]
    def engineDisplayName: Option[String]
    def getEngineName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("engineName", engineName)
    def getSupportsCDC: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("supportsCDC", supportsCDC)
    def getEndpointType: ZIO[
      Any,
      AwsError,
      zio.aws.databasemigration.model.ReplicationEndpointTypeValue
    ] = AwsError.unwrapOptionField("endpointType", endpointType)
    def getReplicationInstanceEngineMinimumVersion: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField(
        "replicationInstanceEngineMinimumVersion",
        replicationInstanceEngineMinimumVersion
      )
    def getEngineDisplayName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("engineDisplayName", engineDisplayName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.databasemigration.model.SupportedEndpointType
  ) extends zio.aws.databasemigration.model.SupportedEndpointType.ReadOnly {
    override val engineName: Option[String] =
      scala.Option(impl.engineName()).map(value => value: String)
    override val supportsCDC: Option[Boolean] =
      scala.Option(impl.supportsCDC()).map(value => value: Boolean)
    override val endpointType
        : Option[zio.aws.databasemigration.model.ReplicationEndpointTypeValue] =
      scala
        .Option(impl.endpointType())
        .map(value =>
          zio.aws.databasemigration.model.ReplicationEndpointTypeValue
            .wrap(value)
        )
    override val replicationInstanceEngineMinimumVersion: Option[String] = scala
      .Option(impl.replicationInstanceEngineMinimumVersion())
      .map(value => value: String)
    override val engineDisplayName: Option[String] =
      scala.Option(impl.engineDisplayName()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.databasemigration.model.SupportedEndpointType
  ): zio.aws.databasemigration.model.SupportedEndpointType.ReadOnly =
    new Wrapper(impl)
}
