package zio.aws.databasemigration.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ModifyReplicationSubnetGroupResponse(
    replicationSubnetGroup: Option[
      zio.aws.databasemigration.model.ReplicationSubnetGroup
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.databasemigration.model.ModifyReplicationSubnetGroupResponse = {
    import ModifyReplicationSubnetGroupResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.databasemigration.model.ModifyReplicationSubnetGroupResponse
      .builder()
      .optionallyWith(
        replicationSubnetGroup.map(value => value.buildAwsValue())
      )(_.replicationSubnetGroup)
      .build()
  }
  def asReadOnly
      : zio.aws.databasemigration.model.ModifyReplicationSubnetGroupResponse.ReadOnly =
    zio.aws.databasemigration.model.ModifyReplicationSubnetGroupResponse
      .wrap(buildAwsValue())
}
object ModifyReplicationSubnetGroupResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.databasemigration.model.ModifyReplicationSubnetGroupResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.databasemigration.model.ModifyReplicationSubnetGroupResponse =
      zio.aws.databasemigration.model.ModifyReplicationSubnetGroupResponse(
        replicationSubnetGroup.map(value => value.asEditable)
      )
    def replicationSubnetGroup: Option[
      zio.aws.databasemigration.model.ReplicationSubnetGroup.ReadOnly
    ]
    def getReplicationSubnetGroup: ZIO[
      Any,
      AwsError,
      zio.aws.databasemigration.model.ReplicationSubnetGroup.ReadOnly
    ] = AwsError.unwrapOptionField(
      "replicationSubnetGroup",
      replicationSubnetGroup
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.databasemigration.model.ModifyReplicationSubnetGroupResponse
  ) extends zio.aws.databasemigration.model.ModifyReplicationSubnetGroupResponse.ReadOnly {
    override val replicationSubnetGroup: Option[
      zio.aws.databasemigration.model.ReplicationSubnetGroup.ReadOnly
    ] = scala
      .Option(impl.replicationSubnetGroup())
      .map(value =>
        zio.aws.databasemigration.model.ReplicationSubnetGroup.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.databasemigration.model.ModifyReplicationSubnetGroupResponse
  ): zio.aws.databasemigration.model.ModifyReplicationSubnetGroupResponse.ReadOnly =
    new Wrapper(impl)
}
