package zio.aws.databasemigration.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class CreateReplicationTaskResponse(
    replicationTask: Option[zio.aws.databasemigration.model.ReplicationTask] =
      None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.databasemigration.model.CreateReplicationTaskResponse = {
    import CreateReplicationTaskResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.databasemigration.model.CreateReplicationTaskResponse
      .builder()
      .optionallyWith(replicationTask.map(value => value.buildAwsValue()))(
        _.replicationTask
      )
      .build()
  }
  def asReadOnly
      : zio.aws.databasemigration.model.CreateReplicationTaskResponse.ReadOnly =
    zio.aws.databasemigration.model.CreateReplicationTaskResponse
      .wrap(buildAwsValue())
}
object CreateReplicationTaskResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.databasemigration.model.CreateReplicationTaskResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.databasemigration.model.CreateReplicationTaskResponse =
      zio.aws.databasemigration.model.CreateReplicationTaskResponse(
        replicationTask.map(value => value.asEditable)
      )
    def replicationTask
        : Option[zio.aws.databasemigration.model.ReplicationTask.ReadOnly]
    def getReplicationTask: ZIO[
      Any,
      AwsError,
      zio.aws.databasemigration.model.ReplicationTask.ReadOnly
    ] = AwsError.unwrapOptionField("replicationTask", replicationTask)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.databasemigration.model.CreateReplicationTaskResponse
  ) extends zio.aws.databasemigration.model.CreateReplicationTaskResponse.ReadOnly {
    override val replicationTask
        : Option[zio.aws.databasemigration.model.ReplicationTask.ReadOnly] =
      scala
        .Option(impl.replicationTask())
        .map(value =>
          zio.aws.databasemigration.model.ReplicationTask.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.databasemigration.model.CreateReplicationTaskResponse
  ): zio.aws.databasemigration.model.CreateReplicationTaskResponse.ReadOnly =
    new Wrapper(impl)
}
