package zio.aws.databasemigration.model
import scala.jdk.CollectionConverters._
sealed trait SslSecurityProtocolValue {
  def unwrap: software.amazon.awssdk.services.databasemigration.model.SslSecurityProtocolValue
}
object SslSecurityProtocolValue {
  def wrap(
      value: software.amazon.awssdk.services.databasemigration.model.SslSecurityProtocolValue
  ): zio.aws.databasemigration.model.SslSecurityProtocolValue = value match {
    case software.amazon.awssdk.services.databasemigration.model.SslSecurityProtocolValue.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.databasemigration.model.SslSecurityProtocolValue.PLAINTEXT =>
      val r = plaintext
      r
    case software.amazon.awssdk.services.databasemigration.model.SslSecurityProtocolValue.SSL_ENCRYPTION =>
      val r = `ssl-encryption`
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.databasemigration.model.SslSecurityProtocolValue {
    override def unwrap
        : software.amazon.awssdk.services.databasemigration.model.SslSecurityProtocolValue =
      software.amazon.awssdk.services.databasemigration.model.SslSecurityProtocolValue.UNKNOWN_TO_SDK_VERSION
  }
  case object plaintext
      extends zio.aws.databasemigration.model.SslSecurityProtocolValue {
    override def unwrap
        : software.amazon.awssdk.services.databasemigration.model.SslSecurityProtocolValue =
      software.amazon.awssdk.services.databasemigration.model.SslSecurityProtocolValue.PLAINTEXT
  }
  case object `ssl-encryption`
      extends zio.aws.databasemigration.model.SslSecurityProtocolValue {
    override def unwrap
        : software.amazon.awssdk.services.databasemigration.model.SslSecurityProtocolValue =
      software.amazon.awssdk.services.databasemigration.model.SslSecurityProtocolValue.SSL_ENCRYPTION
  }
}
