package zio.aws.databasemigration.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.databasemigration.model.primitives.{
  SecretString,
  Integer,
  IntegerOptional,
  BooleanOptional
}
import scala.jdk.CollectionConverters._
final case class OracleSettings(
    addSupplementalLogging: Option[BooleanOptional] = None,
    archivedLogDestId: Option[IntegerOptional] = None,
    additionalArchivedLogDestId: Option[IntegerOptional] = None,
    extraArchivedLogDestIds: Option[Iterable[Integer]] = None,
    allowSelectNestedTables: Option[BooleanOptional] = None,
    parallelAsmReadThreads: Option[IntegerOptional] = None,
    readAheadBlocks: Option[IntegerOptional] = None,
    accessAlternateDirectly: Option[BooleanOptional] = None,
    useAlternateFolderForOnline: Option[BooleanOptional] = None,
    oraclePathPrefix: Option[String] = None,
    usePathPrefix: Option[String] = None,
    replacePathPrefix: Option[BooleanOptional] = None,
    enableHomogenousTablespace: Option[BooleanOptional] = None,
    directPathNoLog: Option[BooleanOptional] = None,
    archivedLogsOnly: Option[BooleanOptional] = None,
    asmPassword: Option[SecretString] = None,
    asmServer: Option[String] = None,
    asmUser: Option[String] = None,
    charLengthSemantics: Option[
      zio.aws.databasemigration.model.CharLengthSemantics
    ] = None,
    databaseName: Option[String] = None,
    directPathParallelLoad: Option[BooleanOptional] = None,
    failTasksOnLobTruncation: Option[BooleanOptional] = None,
    numberDatatypeScale: Option[IntegerOptional] = None,
    password: Option[SecretString] = None,
    port: Option[IntegerOptional] = None,
    readTableSpaceName: Option[BooleanOptional] = None,
    retryInterval: Option[IntegerOptional] = None,
    securityDbEncryption: Option[SecretString] = None,
    securityDbEncryptionName: Option[String] = None,
    serverName: Option[String] = None,
    spatialDataOptionToGeoJsonFunctionName: Option[String] = None,
    standbyDelayTime: Option[IntegerOptional] = None,
    username: Option[String] = None,
    useBFile: Option[BooleanOptional] = None,
    useDirectPathFullLoad: Option[BooleanOptional] = None,
    useLogminerReader: Option[BooleanOptional] = None,
    secretsManagerAccessRoleArn: Option[String] = None,
    secretsManagerSecretId: Option[String] = None,
    secretsManagerOracleAsmAccessRoleArn: Option[String] = None,
    secretsManagerOracleAsmSecretId: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.databasemigration.model.OracleSettings = {
    import OracleSettings.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.databasemigration.model.OracleSettings
      .builder()
      .optionallyWith(
        addSupplementalLogging.map(value => value: java.lang.Boolean)
      )(_.addSupplementalLogging)
      .optionallyWith(archivedLogDestId.map(value => value: java.lang.Integer))(
        _.archivedLogDestId
      )
      .optionallyWith(
        additionalArchivedLogDestId.map(value => value: java.lang.Integer)
      )(_.additionalArchivedLogDestId)
      .optionallyWith(
        extraArchivedLogDestIds.map(value =>
          value.map { item =>
            item: java.lang.Integer
          }.asJavaCollection
        )
      )(_.extraArchivedLogDestIds)
      .optionallyWith(
        allowSelectNestedTables.map(value => value: java.lang.Boolean)
      )(_.allowSelectNestedTables)
      .optionallyWith(
        parallelAsmReadThreads.map(value => value: java.lang.Integer)
      )(_.parallelAsmReadThreads)
      .optionallyWith(readAheadBlocks.map(value => value: java.lang.Integer))(
        _.readAheadBlocks
      )
      .optionallyWith(
        accessAlternateDirectly.map(value => value: java.lang.Boolean)
      )(_.accessAlternateDirectly)
      .optionallyWith(
        useAlternateFolderForOnline.map(value => value: java.lang.Boolean)
      )(_.useAlternateFolderForOnline)
      .optionallyWith(oraclePathPrefix.map(value => value: java.lang.String))(
        _.oraclePathPrefix
      )
      .optionallyWith(usePathPrefix.map(value => value: java.lang.String))(
        _.usePathPrefix
      )
      .optionallyWith(replacePathPrefix.map(value => value: java.lang.Boolean))(
        _.replacePathPrefix
      )
      .optionallyWith(
        enableHomogenousTablespace.map(value => value: java.lang.Boolean)
      )(_.enableHomogenousTablespace)
      .optionallyWith(directPathNoLog.map(value => value: java.lang.Boolean))(
        _.directPathNoLog
      )
      .optionallyWith(archivedLogsOnly.map(value => value: java.lang.Boolean))(
        _.archivedLogsOnly
      )
      .optionallyWith(
        asmPassword.map(value => SecretString.unwrap(value): java.lang.String)
      )(_.asmPassword)
      .optionallyWith(asmServer.map(value => value: java.lang.String))(
        _.asmServer
      )
      .optionallyWith(asmUser.map(value => value: java.lang.String))(_.asmUser)
      .optionallyWith(charLengthSemantics.map(value => value.unwrap))(
        _.charLengthSemantics
      )
      .optionallyWith(databaseName.map(value => value: java.lang.String))(
        _.databaseName
      )
      .optionallyWith(
        directPathParallelLoad.map(value => value: java.lang.Boolean)
      )(_.directPathParallelLoad)
      .optionallyWith(
        failTasksOnLobTruncation.map(value => value: java.lang.Boolean)
      )(_.failTasksOnLobTruncation)
      .optionallyWith(
        numberDatatypeScale.map(value => value: java.lang.Integer)
      )(_.numberDatatypeScale)
      .optionallyWith(
        password.map(value => SecretString.unwrap(value): java.lang.String)
      )(_.password)
      .optionallyWith(port.map(value => value: java.lang.Integer))(_.port)
      .optionallyWith(
        readTableSpaceName.map(value => value: java.lang.Boolean)
      )(_.readTableSpaceName)
      .optionallyWith(retryInterval.map(value => value: java.lang.Integer))(
        _.retryInterval
      )
      .optionallyWith(
        securityDbEncryption.map(value =>
          SecretString.unwrap(value): java.lang.String
        )
      )(_.securityDbEncryption)
      .optionallyWith(
        securityDbEncryptionName.map(value => value: java.lang.String)
      )(_.securityDbEncryptionName)
      .optionallyWith(serverName.map(value => value: java.lang.String))(
        _.serverName
      )
      .optionallyWith(
        spatialDataOptionToGeoJsonFunctionName.map(value =>
          value: java.lang.String
        )
      )(_.spatialDataOptionToGeoJsonFunctionName)
      .optionallyWith(standbyDelayTime.map(value => value: java.lang.Integer))(
        _.standbyDelayTime
      )
      .optionallyWith(username.map(value => value: java.lang.String))(
        _.username
      )
      .optionallyWith(useBFile.map(value => value: java.lang.Boolean))(
        _.useBFile
      )
      .optionallyWith(
        useDirectPathFullLoad.map(value => value: java.lang.Boolean)
      )(_.useDirectPathFullLoad)
      .optionallyWith(useLogminerReader.map(value => value: java.lang.Boolean))(
        _.useLogminerReader
      )
      .optionallyWith(
        secretsManagerAccessRoleArn.map(value => value: java.lang.String)
      )(_.secretsManagerAccessRoleArn)
      .optionallyWith(
        secretsManagerSecretId.map(value => value: java.lang.String)
      )(_.secretsManagerSecretId)
      .optionallyWith(
        secretsManagerOracleAsmAccessRoleArn.map(value =>
          value: java.lang.String
        )
      )(_.secretsManagerOracleAsmAccessRoleArn)
      .optionallyWith(
        secretsManagerOracleAsmSecretId.map(value => value: java.lang.String)
      )(_.secretsManagerOracleAsmSecretId)
      .build()
  }
  def asReadOnly: zio.aws.databasemigration.model.OracleSettings.ReadOnly =
    zio.aws.databasemigration.model.OracleSettings.wrap(buildAwsValue())
}
object OracleSettings {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.databasemigration.model.OracleSettings
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.databasemigration.model.OracleSettings =
      zio.aws.databasemigration.model.OracleSettings(
        addSupplementalLogging.map(value => value),
        archivedLogDestId.map(value => value),
        additionalArchivedLogDestId.map(value => value),
        extraArchivedLogDestIds.map(value => value),
        allowSelectNestedTables.map(value => value),
        parallelAsmReadThreads.map(value => value),
        readAheadBlocks.map(value => value),
        accessAlternateDirectly.map(value => value),
        useAlternateFolderForOnline.map(value => value),
        oraclePathPrefix.map(value => value),
        usePathPrefix.map(value => value),
        replacePathPrefix.map(value => value),
        enableHomogenousTablespace.map(value => value),
        directPathNoLog.map(value => value),
        archivedLogsOnly.map(value => value),
        asmPassword.map(value => value),
        asmServer.map(value => value),
        asmUser.map(value => value),
        charLengthSemantics.map(value => value),
        databaseName.map(value => value),
        directPathParallelLoad.map(value => value),
        failTasksOnLobTruncation.map(value => value),
        numberDatatypeScale.map(value => value),
        password.map(value => value),
        port.map(value => value),
        readTableSpaceName.map(value => value),
        retryInterval.map(value => value),
        securityDbEncryption.map(value => value),
        securityDbEncryptionName.map(value => value),
        serverName.map(value => value),
        spatialDataOptionToGeoJsonFunctionName.map(value => value),
        standbyDelayTime.map(value => value),
        username.map(value => value),
        useBFile.map(value => value),
        useDirectPathFullLoad.map(value => value),
        useLogminerReader.map(value => value),
        secretsManagerAccessRoleArn.map(value => value),
        secretsManagerSecretId.map(value => value),
        secretsManagerOracleAsmAccessRoleArn.map(value => value),
        secretsManagerOracleAsmSecretId.map(value => value)
      )
    def addSupplementalLogging: Option[BooleanOptional]
    def archivedLogDestId: Option[IntegerOptional]
    def additionalArchivedLogDestId: Option[IntegerOptional]
    def extraArchivedLogDestIds: Option[List[Integer]]
    def allowSelectNestedTables: Option[BooleanOptional]
    def parallelAsmReadThreads: Option[IntegerOptional]
    def readAheadBlocks: Option[IntegerOptional]
    def accessAlternateDirectly: Option[BooleanOptional]
    def useAlternateFolderForOnline: Option[BooleanOptional]
    def oraclePathPrefix: Option[String]
    def usePathPrefix: Option[String]
    def replacePathPrefix: Option[BooleanOptional]
    def enableHomogenousTablespace: Option[BooleanOptional]
    def directPathNoLog: Option[BooleanOptional]
    def archivedLogsOnly: Option[BooleanOptional]
    def asmPassword: Option[SecretString]
    def asmServer: Option[String]
    def asmUser: Option[String]
    def charLengthSemantics
        : Option[zio.aws.databasemigration.model.CharLengthSemantics]
    def databaseName: Option[String]
    def directPathParallelLoad: Option[BooleanOptional]
    def failTasksOnLobTruncation: Option[BooleanOptional]
    def numberDatatypeScale: Option[IntegerOptional]
    def password: Option[SecretString]
    def port: Option[IntegerOptional]
    def readTableSpaceName: Option[BooleanOptional]
    def retryInterval: Option[IntegerOptional]
    def securityDbEncryption: Option[SecretString]
    def securityDbEncryptionName: Option[String]
    def serverName: Option[String]
    def spatialDataOptionToGeoJsonFunctionName: Option[String]
    def standbyDelayTime: Option[IntegerOptional]
    def username: Option[String]
    def useBFile: Option[BooleanOptional]
    def useDirectPathFullLoad: Option[BooleanOptional]
    def useLogminerReader: Option[BooleanOptional]
    def secretsManagerAccessRoleArn: Option[String]
    def secretsManagerSecretId: Option[String]
    def secretsManagerOracleAsmAccessRoleArn: Option[String]
    def secretsManagerOracleAsmSecretId: Option[String]
    def getAddSupplementalLogging: ZIO[Any, AwsError, BooleanOptional] =
      AwsError.unwrapOptionField(
        "addSupplementalLogging",
        addSupplementalLogging
      )
    def getArchivedLogDestId: ZIO[Any, AwsError, IntegerOptional] =
      AwsError.unwrapOptionField("archivedLogDestId", archivedLogDestId)
    def getAdditionalArchivedLogDestId: ZIO[Any, AwsError, IntegerOptional] =
      AwsError.unwrapOptionField(
        "additionalArchivedLogDestId",
        additionalArchivedLogDestId
      )
    def getExtraArchivedLogDestIds: ZIO[Any, AwsError, List[Integer]] = AwsError
      .unwrapOptionField("extraArchivedLogDestIds", extraArchivedLogDestIds)
    def getAllowSelectNestedTables: ZIO[Any, AwsError, BooleanOptional] =
      AwsError.unwrapOptionField(
        "allowSelectNestedTables",
        allowSelectNestedTables
      )
    def getParallelAsmReadThreads: ZIO[Any, AwsError, IntegerOptional] =
      AwsError.unwrapOptionField(
        "parallelAsmReadThreads",
        parallelAsmReadThreads
      )
    def getReadAheadBlocks: ZIO[Any, AwsError, IntegerOptional] =
      AwsError.unwrapOptionField("readAheadBlocks", readAheadBlocks)
    def getAccessAlternateDirectly: ZIO[Any, AwsError, BooleanOptional] =
      AwsError.unwrapOptionField(
        "accessAlternateDirectly",
        accessAlternateDirectly
      )
    def getUseAlternateFolderForOnline: ZIO[Any, AwsError, BooleanOptional] =
      AwsError.unwrapOptionField(
        "useAlternateFolderForOnline",
        useAlternateFolderForOnline
      )
    def getOraclePathPrefix: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("oraclePathPrefix", oraclePathPrefix)
    def getUsePathPrefix: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("usePathPrefix", usePathPrefix)
    def getReplacePathPrefix: ZIO[Any, AwsError, BooleanOptional] =
      AwsError.unwrapOptionField("replacePathPrefix", replacePathPrefix)
    def getEnableHomogenousTablespace: ZIO[Any, AwsError, BooleanOptional] =
      AwsError.unwrapOptionField(
        "enableHomogenousTablespace",
        enableHomogenousTablespace
      )
    def getDirectPathNoLog: ZIO[Any, AwsError, BooleanOptional] =
      AwsError.unwrapOptionField("directPathNoLog", directPathNoLog)
    def getArchivedLogsOnly: ZIO[Any, AwsError, BooleanOptional] =
      AwsError.unwrapOptionField("archivedLogsOnly", archivedLogsOnly)
    def getAsmPassword: ZIO[Any, AwsError, SecretString] =
      AwsError.unwrapOptionField("asmPassword", asmPassword)
    def getAsmServer: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("asmServer", asmServer)
    def getAsmUser: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("asmUser", asmUser)
    def getCharLengthSemantics: ZIO[
      Any,
      AwsError,
      zio.aws.databasemigration.model.CharLengthSemantics
    ] = AwsError.unwrapOptionField("charLengthSemantics", charLengthSemantics)
    def getDatabaseName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("databaseName", databaseName)
    def getDirectPathParallelLoad: ZIO[Any, AwsError, BooleanOptional] =
      AwsError.unwrapOptionField(
        "directPathParallelLoad",
        directPathParallelLoad
      )
    def getFailTasksOnLobTruncation: ZIO[Any, AwsError, BooleanOptional] =
      AwsError.unwrapOptionField(
        "failTasksOnLobTruncation",
        failTasksOnLobTruncation
      )
    def getNumberDatatypeScale: ZIO[Any, AwsError, IntegerOptional] =
      AwsError.unwrapOptionField("numberDatatypeScale", numberDatatypeScale)
    def getPassword: ZIO[Any, AwsError, SecretString] =
      AwsError.unwrapOptionField("password", password)
    def getPort: ZIO[Any, AwsError, IntegerOptional] =
      AwsError.unwrapOptionField("port", port)
    def getReadTableSpaceName: ZIO[Any, AwsError, BooleanOptional] =
      AwsError.unwrapOptionField("readTableSpaceName", readTableSpaceName)
    def getRetryInterval: ZIO[Any, AwsError, IntegerOptional] =
      AwsError.unwrapOptionField("retryInterval", retryInterval)
    def getSecurityDbEncryption: ZIO[Any, AwsError, SecretString] =
      AwsError.unwrapOptionField("securityDbEncryption", securityDbEncryption)
    def getSecurityDbEncryptionName: ZIO[Any, AwsError, String] = AwsError
      .unwrapOptionField("securityDbEncryptionName", securityDbEncryptionName)
    def getServerName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("serverName", serverName)
    def getSpatialDataOptionToGeoJsonFunctionName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField(
        "spatialDataOptionToGeoJsonFunctionName",
        spatialDataOptionToGeoJsonFunctionName
      )
    def getStandbyDelayTime: ZIO[Any, AwsError, IntegerOptional] =
      AwsError.unwrapOptionField("standbyDelayTime", standbyDelayTime)
    def getUsername: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("username", username)
    def getUseBFile: ZIO[Any, AwsError, BooleanOptional] =
      AwsError.unwrapOptionField("useBFile", useBFile)
    def getUseDirectPathFullLoad: ZIO[Any, AwsError, BooleanOptional] =
      AwsError.unwrapOptionField("useDirectPathFullLoad", useDirectPathFullLoad)
    def getUseLogminerReader: ZIO[Any, AwsError, BooleanOptional] =
      AwsError.unwrapOptionField("useLogminerReader", useLogminerReader)
    def getSecretsManagerAccessRoleArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField(
        "secretsManagerAccessRoleArn",
        secretsManagerAccessRoleArn
      )
    def getSecretsManagerSecretId: ZIO[Any, AwsError, String] = AwsError
      .unwrapOptionField("secretsManagerSecretId", secretsManagerSecretId)
    def getSecretsManagerOracleAsmAccessRoleArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField(
        "secretsManagerOracleAsmAccessRoleArn",
        secretsManagerOracleAsmAccessRoleArn
      )
    def getSecretsManagerOracleAsmSecretId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField(
        "secretsManagerOracleAsmSecretId",
        secretsManagerOracleAsmSecretId
      )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.databasemigration.model.OracleSettings
  ) extends zio.aws.databasemigration.model.OracleSettings.ReadOnly {
    override val addSupplementalLogging: Option[BooleanOptional] = scala
      .Option(impl.addSupplementalLogging())
      .map(value => value: BooleanOptional)
    override val archivedLogDestId: Option[IntegerOptional] = scala
      .Option(impl.archivedLogDestId())
      .map(value => value: IntegerOptional)
    override val additionalArchivedLogDestId: Option[IntegerOptional] = scala
      .Option(impl.additionalArchivedLogDestId())
      .map(value => value: IntegerOptional)
    override val extraArchivedLogDestIds: Option[List[Integer]] = scala
      .Option(impl.extraArchivedLogDestIds())
      .map(value =>
        value.asScala.map { item =>
          item: Integer
        }.toList
      )
    override val allowSelectNestedTables: Option[BooleanOptional] = scala
      .Option(impl.allowSelectNestedTables())
      .map(value => value: BooleanOptional)
    override val parallelAsmReadThreads: Option[IntegerOptional] = scala
      .Option(impl.parallelAsmReadThreads())
      .map(value => value: IntegerOptional)
    override val readAheadBlocks: Option[IntegerOptional] =
      scala.Option(impl.readAheadBlocks()).map(value => value: IntegerOptional)
    override val accessAlternateDirectly: Option[BooleanOptional] = scala
      .Option(impl.accessAlternateDirectly())
      .map(value => value: BooleanOptional)
    override val useAlternateFolderForOnline: Option[BooleanOptional] = scala
      .Option(impl.useAlternateFolderForOnline())
      .map(value => value: BooleanOptional)
    override val oraclePathPrefix: Option[String] =
      scala.Option(impl.oraclePathPrefix()).map(value => value: String)
    override val usePathPrefix: Option[String] =
      scala.Option(impl.usePathPrefix()).map(value => value: String)
    override val replacePathPrefix: Option[BooleanOptional] = scala
      .Option(impl.replacePathPrefix())
      .map(value => value: BooleanOptional)
    override val enableHomogenousTablespace: Option[BooleanOptional] = scala
      .Option(impl.enableHomogenousTablespace())
      .map(value => value: BooleanOptional)
    override val directPathNoLog: Option[BooleanOptional] =
      scala.Option(impl.directPathNoLog()).map(value => value: BooleanOptional)
    override val archivedLogsOnly: Option[BooleanOptional] =
      scala.Option(impl.archivedLogsOnly()).map(value => value: BooleanOptional)
    override val asmPassword: Option[SecretString] = scala
      .Option(impl.asmPassword())
      .map(value =>
        zio.aws.databasemigration.model.primitives.SecretString(value)
      )
    override val asmServer: Option[String] =
      scala.Option(impl.asmServer()).map(value => value: String)
    override val asmUser: Option[String] =
      scala.Option(impl.asmUser()).map(value => value: String)
    override val charLengthSemantics
        : Option[zio.aws.databasemigration.model.CharLengthSemantics] = scala
      .Option(impl.charLengthSemantics())
      .map(value =>
        zio.aws.databasemigration.model.CharLengthSemantics.wrap(value)
      )
    override val databaseName: Option[String] =
      scala.Option(impl.databaseName()).map(value => value: String)
    override val directPathParallelLoad: Option[BooleanOptional] = scala
      .Option(impl.directPathParallelLoad())
      .map(value => value: BooleanOptional)
    override val failTasksOnLobTruncation: Option[BooleanOptional] = scala
      .Option(impl.failTasksOnLobTruncation())
      .map(value => value: BooleanOptional)
    override val numberDatatypeScale: Option[IntegerOptional] = scala
      .Option(impl.numberDatatypeScale())
      .map(value => value: IntegerOptional)
    override val password: Option[SecretString] = scala
      .Option(impl.password())
      .map(value =>
        zio.aws.databasemigration.model.primitives.SecretString(value)
      )
    override val port: Option[IntegerOptional] =
      scala.Option(impl.port()).map(value => value: IntegerOptional)
    override val readTableSpaceName: Option[BooleanOptional] = scala
      .Option(impl.readTableSpaceName())
      .map(value => value: BooleanOptional)
    override val retryInterval: Option[IntegerOptional] =
      scala.Option(impl.retryInterval()).map(value => value: IntegerOptional)
    override val securityDbEncryption: Option[SecretString] = scala
      .Option(impl.securityDbEncryption())
      .map(value =>
        zio.aws.databasemigration.model.primitives.SecretString(value)
      )
    override val securityDbEncryptionName: Option[String] =
      scala.Option(impl.securityDbEncryptionName()).map(value => value: String)
    override val serverName: Option[String] =
      scala.Option(impl.serverName()).map(value => value: String)
    override val spatialDataOptionToGeoJsonFunctionName: Option[String] = scala
      .Option(impl.spatialDataOptionToGeoJsonFunctionName())
      .map(value => value: String)
    override val standbyDelayTime: Option[IntegerOptional] =
      scala.Option(impl.standbyDelayTime()).map(value => value: IntegerOptional)
    override val username: Option[String] =
      scala.Option(impl.username()).map(value => value: String)
    override val useBFile: Option[BooleanOptional] =
      scala.Option(impl.useBFile()).map(value => value: BooleanOptional)
    override val useDirectPathFullLoad: Option[BooleanOptional] = scala
      .Option(impl.useDirectPathFullLoad())
      .map(value => value: BooleanOptional)
    override val useLogminerReader: Option[BooleanOptional] = scala
      .Option(impl.useLogminerReader())
      .map(value => value: BooleanOptional)
    override val secretsManagerAccessRoleArn: Option[String] = scala
      .Option(impl.secretsManagerAccessRoleArn())
      .map(value => value: String)
    override val secretsManagerSecretId: Option[String] =
      scala.Option(impl.secretsManagerSecretId()).map(value => value: String)
    override val secretsManagerOracleAsmAccessRoleArn: Option[String] = scala
      .Option(impl.secretsManagerOracleAsmAccessRoleArn())
      .map(value => value: String)
    override val secretsManagerOracleAsmSecretId: Option[String] = scala
      .Option(impl.secretsManagerOracleAsmSecretId())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.databasemigration.model.OracleSettings
  ): zio.aws.databasemigration.model.OracleSettings.ReadOnly = new Wrapper(impl)
}
