package zio.aws.databasemigration.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.databasemigration.model.primitives.{
  BooleanOptional,
  IntegerOptional
}
import scala.jdk.CollectionConverters._
final case class DescribeReplicationTasksRequest(
    filters: Option[Iterable[zio.aws.databasemigration.model.Filter]] = None,
    maxRecords: Option[IntegerOptional] = None,
    marker: Option[String] = None,
    withoutSettings: Option[BooleanOptional] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.databasemigration.model.DescribeReplicationTasksRequest = {
    import DescribeReplicationTasksRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.databasemigration.model.DescribeReplicationTasksRequest
      .builder()
      .optionallyWith(
        filters.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.filters)
      .optionallyWith(maxRecords.map(value => value: Integer))(_.maxRecords)
      .optionallyWith(marker.map(value => value: java.lang.String))(_.marker)
      .optionallyWith(withoutSettings.map(value => value: java.lang.Boolean))(
        _.withoutSettings
      )
      .build()
  }
  def asReadOnly
      : zio.aws.databasemigration.model.DescribeReplicationTasksRequest.ReadOnly =
    zio.aws.databasemigration.model.DescribeReplicationTasksRequest
      .wrap(buildAwsValue())
}
object DescribeReplicationTasksRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.databasemigration.model.DescribeReplicationTasksRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.databasemigration.model.DescribeReplicationTasksRequest =
      zio.aws.databasemigration.model.DescribeReplicationTasksRequest(
        filters.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        maxRecords.map(value => value),
        marker.map(value => value),
        withoutSettings.map(value => value)
      )
    def filters: Option[List[zio.aws.databasemigration.model.Filter.ReadOnly]]
    def maxRecords: Option[IntegerOptional]
    def marker: Option[String]
    def withoutSettings: Option[BooleanOptional]
    def getFilters: ZIO[Any, AwsError, List[
      zio.aws.databasemigration.model.Filter.ReadOnly
    ]] = AwsError.unwrapOptionField("filters", filters)
    def getMaxRecords: ZIO[Any, AwsError, IntegerOptional] =
      AwsError.unwrapOptionField("maxRecords", maxRecords)
    def getMarker: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("marker", marker)
    def getWithoutSettings: ZIO[Any, AwsError, BooleanOptional] =
      AwsError.unwrapOptionField("withoutSettings", withoutSettings)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.databasemigration.model.DescribeReplicationTasksRequest
  ) extends zio.aws.databasemigration.model.DescribeReplicationTasksRequest.ReadOnly {
    override val filters
        : Option[List[zio.aws.databasemigration.model.Filter.ReadOnly]] = scala
      .Option(impl.filters())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.databasemigration.model.Filter.wrap(item)
        }.toList
      )
    override val maxRecords: Option[IntegerOptional] =
      scala.Option(impl.maxRecords()).map(value => value: IntegerOptional)
    override val marker: Option[String] =
      scala.Option(impl.marker()).map(value => value: String)
    override val withoutSettings: Option[BooleanOptional] =
      scala.Option(impl.withoutSettings()).map(value => value: BooleanOptional)
  }
  def wrap(
      impl: software.amazon.awssdk.services.databasemigration.model.DescribeReplicationTasksRequest
  ): zio.aws.databasemigration.model.DescribeReplicationTasksRequest.ReadOnly =
    new Wrapper(impl)
}
