package zio.aws.databasemigration.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.databasemigration.model.primitives.BooleanOptional
import scala.jdk.CollectionConverters._
final case class KinesisSettings(
    streamArn: Option[String] = None,
    messageFormat: Option[zio.aws.databasemigration.model.MessageFormatValue] =
      None,
    serviceAccessRoleArn: Option[String] = None,
    includeTransactionDetails: Option[BooleanOptional] = None,
    includePartitionValue: Option[BooleanOptional] = None,
    partitionIncludeSchemaTable: Option[BooleanOptional] = None,
    includeTableAlterOperations: Option[BooleanOptional] = None,
    includeControlDetails: Option[BooleanOptional] = None,
    includeNullAndEmpty: Option[BooleanOptional] = None,
    noHexPrefix: Option[BooleanOptional] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.databasemigration.model.KinesisSettings = {
    import KinesisSettings.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.databasemigration.model.KinesisSettings
      .builder()
      .optionallyWith(streamArn.map(value => value: java.lang.String))(
        _.streamArn
      )
      .optionallyWith(messageFormat.map(value => value.unwrap))(_.messageFormat)
      .optionallyWith(
        serviceAccessRoleArn.map(value => value: java.lang.String)
      )(_.serviceAccessRoleArn)
      .optionallyWith(
        includeTransactionDetails.map(value => value: java.lang.Boolean)
      )(_.includeTransactionDetails)
      .optionallyWith(
        includePartitionValue.map(value => value: java.lang.Boolean)
      )(_.includePartitionValue)
      .optionallyWith(
        partitionIncludeSchemaTable.map(value => value: java.lang.Boolean)
      )(_.partitionIncludeSchemaTable)
      .optionallyWith(
        includeTableAlterOperations.map(value => value: java.lang.Boolean)
      )(_.includeTableAlterOperations)
      .optionallyWith(
        includeControlDetails.map(value => value: java.lang.Boolean)
      )(_.includeControlDetails)
      .optionallyWith(
        includeNullAndEmpty.map(value => value: java.lang.Boolean)
      )(_.includeNullAndEmpty)
      .optionallyWith(noHexPrefix.map(value => value: java.lang.Boolean))(
        _.noHexPrefix
      )
      .build()
  }
  def asReadOnly: zio.aws.databasemigration.model.KinesisSettings.ReadOnly =
    zio.aws.databasemigration.model.KinesisSettings.wrap(buildAwsValue())
}
object KinesisSettings {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.databasemigration.model.KinesisSettings
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.databasemigration.model.KinesisSettings =
      zio.aws.databasemigration.model.KinesisSettings(
        streamArn.map(value => value),
        messageFormat.map(value => value),
        serviceAccessRoleArn.map(value => value),
        includeTransactionDetails.map(value => value),
        includePartitionValue.map(value => value),
        partitionIncludeSchemaTable.map(value => value),
        includeTableAlterOperations.map(value => value),
        includeControlDetails.map(value => value),
        includeNullAndEmpty.map(value => value),
        noHexPrefix.map(value => value)
      )
    def streamArn: Option[String]
    def messageFormat
        : Option[zio.aws.databasemigration.model.MessageFormatValue]
    def serviceAccessRoleArn: Option[String]
    def includeTransactionDetails: Option[BooleanOptional]
    def includePartitionValue: Option[BooleanOptional]
    def partitionIncludeSchemaTable: Option[BooleanOptional]
    def includeTableAlterOperations: Option[BooleanOptional]
    def includeControlDetails: Option[BooleanOptional]
    def includeNullAndEmpty: Option[BooleanOptional]
    def noHexPrefix: Option[BooleanOptional]
    def getStreamArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("streamArn", streamArn)
    def getMessageFormat: ZIO[
      Any,
      AwsError,
      zio.aws.databasemigration.model.MessageFormatValue
    ] = AwsError.unwrapOptionField("messageFormat", messageFormat)
    def getServiceAccessRoleArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("serviceAccessRoleArn", serviceAccessRoleArn)
    def getIncludeTransactionDetails: ZIO[Any, AwsError, BooleanOptional] =
      AwsError.unwrapOptionField(
        "includeTransactionDetails",
        includeTransactionDetails
      )
    def getIncludePartitionValue: ZIO[Any, AwsError, BooleanOptional] =
      AwsError.unwrapOptionField("includePartitionValue", includePartitionValue)
    def getPartitionIncludeSchemaTable: ZIO[Any, AwsError, BooleanOptional] =
      AwsError.unwrapOptionField(
        "partitionIncludeSchemaTable",
        partitionIncludeSchemaTable
      )
    def getIncludeTableAlterOperations: ZIO[Any, AwsError, BooleanOptional] =
      AwsError.unwrapOptionField(
        "includeTableAlterOperations",
        includeTableAlterOperations
      )
    def getIncludeControlDetails: ZIO[Any, AwsError, BooleanOptional] =
      AwsError.unwrapOptionField("includeControlDetails", includeControlDetails)
    def getIncludeNullAndEmpty: ZIO[Any, AwsError, BooleanOptional] =
      AwsError.unwrapOptionField("includeNullAndEmpty", includeNullAndEmpty)
    def getNoHexPrefix: ZIO[Any, AwsError, BooleanOptional] =
      AwsError.unwrapOptionField("noHexPrefix", noHexPrefix)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.databasemigration.model.KinesisSettings
  ) extends zio.aws.databasemigration.model.KinesisSettings.ReadOnly {
    override val streamArn: Option[String] =
      scala.Option(impl.streamArn()).map(value => value: String)
    override val messageFormat
        : Option[zio.aws.databasemigration.model.MessageFormatValue] = scala
      .Option(impl.messageFormat())
      .map(value =>
        zio.aws.databasemigration.model.MessageFormatValue.wrap(value)
      )
    override val serviceAccessRoleArn: Option[String] =
      scala.Option(impl.serviceAccessRoleArn()).map(value => value: String)
    override val includeTransactionDetails: Option[BooleanOptional] = scala
      .Option(impl.includeTransactionDetails())
      .map(value => value: BooleanOptional)
    override val includePartitionValue: Option[BooleanOptional] = scala
      .Option(impl.includePartitionValue())
      .map(value => value: BooleanOptional)
    override val partitionIncludeSchemaTable: Option[BooleanOptional] = scala
      .Option(impl.partitionIncludeSchemaTable())
      .map(value => value: BooleanOptional)
    override val includeTableAlterOperations: Option[BooleanOptional] = scala
      .Option(impl.includeTableAlterOperations())
      .map(value => value: BooleanOptional)
    override val includeControlDetails: Option[BooleanOptional] = scala
      .Option(impl.includeControlDetails())
      .map(value => value: BooleanOptional)
    override val includeNullAndEmpty: Option[BooleanOptional] = scala
      .Option(impl.includeNullAndEmpty())
      .map(value => value: BooleanOptional)
    override val noHexPrefix: Option[BooleanOptional] =
      scala.Option(impl.noHexPrefix()).map(value => value: BooleanOptional)
  }
  def wrap(
      impl: software.amazon.awssdk.services.databasemigration.model.KinesisSettings
  ): zio.aws.databasemigration.model.KinesisSettings.ReadOnly = new Wrapper(
    impl
  )
}
