package zio.aws.databasemigration.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ReplicationInstanceTaskLog(
    replicationTaskName: Option[String] = None,
    replicationTaskArn: Option[String] = None,
    replicationInstanceTaskLogSize: Option[Long] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.databasemigration.model.ReplicationInstanceTaskLog = {
    import ReplicationInstanceTaskLog.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.databasemigration.model.ReplicationInstanceTaskLog
      .builder()
      .optionallyWith(
        replicationTaskName.map(value => value: java.lang.String)
      )(_.replicationTaskName)
      .optionallyWith(replicationTaskArn.map(value => value: java.lang.String))(
        _.replicationTaskArn
      )
      .optionallyWith(
        replicationInstanceTaskLogSize.map(value => value: java.lang.Long)
      )(_.replicationInstanceTaskLogSize)
      .build()
  }
  def asReadOnly
      : zio.aws.databasemigration.model.ReplicationInstanceTaskLog.ReadOnly =
    zio.aws.databasemigration.model.ReplicationInstanceTaskLog
      .wrap(buildAwsValue())
}
object ReplicationInstanceTaskLog {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.databasemigration.model.ReplicationInstanceTaskLog
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.databasemigration.model.ReplicationInstanceTaskLog =
      zio.aws.databasemigration.model.ReplicationInstanceTaskLog(
        replicationTaskName.map(value => value),
        replicationTaskArn.map(value => value),
        replicationInstanceTaskLogSize.map(value => value)
      )
    def replicationTaskName: Option[String]
    def replicationTaskArn: Option[String]
    def replicationInstanceTaskLogSize: Option[Long]
    def getReplicationTaskName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("replicationTaskName", replicationTaskName)
    def getReplicationTaskArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("replicationTaskArn", replicationTaskArn)
    def getReplicationInstanceTaskLogSize: ZIO[Any, AwsError, Long] =
      AwsError.unwrapOptionField(
        "replicationInstanceTaskLogSize",
        replicationInstanceTaskLogSize
      )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.databasemigration.model.ReplicationInstanceTaskLog
  ) extends zio.aws.databasemigration.model.ReplicationInstanceTaskLog.ReadOnly {
    override val replicationTaskName: Option[String] =
      scala.Option(impl.replicationTaskName()).map(value => value: String)
    override val replicationTaskArn: Option[String] =
      scala.Option(impl.replicationTaskArn()).map(value => value: String)
    override val replicationInstanceTaskLogSize: Option[Long] = scala
      .Option(impl.replicationInstanceTaskLogSize())
      .map(value => value: Long)
  }
  def wrap(
      impl: software.amazon.awssdk.services.databasemigration.model.ReplicationInstanceTaskLog
  ): zio.aws.databasemigration.model.ReplicationInstanceTaskLog.ReadOnly =
    new Wrapper(impl)
}
