package zio.aws.databasemigration.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class CreateReplicationSubnetGroupResponse(
    replicationSubnetGroup: Option[
      zio.aws.databasemigration.model.ReplicationSubnetGroup
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.databasemigration.model.CreateReplicationSubnetGroupResponse = {
    import CreateReplicationSubnetGroupResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.databasemigration.model.CreateReplicationSubnetGroupResponse
      .builder()
      .optionallyWith(
        replicationSubnetGroup.map(value => value.buildAwsValue())
      )(_.replicationSubnetGroup)
      .build()
  }
  def asReadOnly
      : zio.aws.databasemigration.model.CreateReplicationSubnetGroupResponse.ReadOnly =
    zio.aws.databasemigration.model.CreateReplicationSubnetGroupResponse
      .wrap(buildAwsValue())
}
object CreateReplicationSubnetGroupResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.databasemigration.model.CreateReplicationSubnetGroupResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.databasemigration.model.CreateReplicationSubnetGroupResponse =
      zio.aws.databasemigration.model.CreateReplicationSubnetGroupResponse(
        replicationSubnetGroup.map(value => value.asEditable)
      )
    def replicationSubnetGroup: Option[
      zio.aws.databasemigration.model.ReplicationSubnetGroup.ReadOnly
    ]
    def getReplicationSubnetGroup: ZIO[
      Any,
      AwsError,
      zio.aws.databasemigration.model.ReplicationSubnetGroup.ReadOnly
    ] = AwsError.unwrapOptionField(
      "replicationSubnetGroup",
      replicationSubnetGroup
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.databasemigration.model.CreateReplicationSubnetGroupResponse
  ) extends zio.aws.databasemigration.model.CreateReplicationSubnetGroupResponse.ReadOnly {
    override val replicationSubnetGroup: Option[
      zio.aws.databasemigration.model.ReplicationSubnetGroup.ReadOnly
    ] = scala
      .Option(impl.replicationSubnetGroup())
      .map(value =>
        zio.aws.databasemigration.model.ReplicationSubnetGroup.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.databasemigration.model.CreateReplicationSubnetGroupResponse
  ): zio.aws.databasemigration.model.CreateReplicationSubnetGroupResponse.ReadOnly =
    new Wrapper(impl)
}
