package zio.aws.databasemigration.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class DeleteReplicationTaskResponse(
    replicationTask: Option[zio.aws.databasemigration.model.ReplicationTask] =
      None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.databasemigration.model.DeleteReplicationTaskResponse = {
    import DeleteReplicationTaskResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.databasemigration.model.DeleteReplicationTaskResponse
      .builder()
      .optionallyWith(replicationTask.map(value => value.buildAwsValue()))(
        _.replicationTask
      )
      .build()
  }
  def asReadOnly
      : zio.aws.databasemigration.model.DeleteReplicationTaskResponse.ReadOnly =
    zio.aws.databasemigration.model.DeleteReplicationTaskResponse
      .wrap(buildAwsValue())
}
object DeleteReplicationTaskResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.databasemigration.model.DeleteReplicationTaskResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.databasemigration.model.DeleteReplicationTaskResponse =
      zio.aws.databasemigration.model.DeleteReplicationTaskResponse(
        replicationTask.map(value => value.asEditable)
      )
    def replicationTask
        : Option[zio.aws.databasemigration.model.ReplicationTask.ReadOnly]
    def getReplicationTask: ZIO[
      Any,
      AwsError,
      zio.aws.databasemigration.model.ReplicationTask.ReadOnly
    ] = AwsError.unwrapOptionField("replicationTask", replicationTask)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.databasemigration.model.DeleteReplicationTaskResponse
  ) extends zio.aws.databasemigration.model.DeleteReplicationTaskResponse.ReadOnly {
    override val replicationTask
        : Option[zio.aws.databasemigration.model.ReplicationTask.ReadOnly] =
      scala
        .Option(impl.replicationTask())
        .map(value =>
          zio.aws.databasemigration.model.ReplicationTask.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.databasemigration.model.DeleteReplicationTaskResponse
  ): zio.aws.databasemigration.model.DeleteReplicationTaskResponse.ReadOnly =
    new Wrapper(impl)
}
