package zio.aws.databasemigration.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ReplicationSubnetGroup(
    replicationSubnetGroupIdentifier: Option[String] = None,
    replicationSubnetGroupDescription: Option[String] = None,
    vpcId: Option[String] = None,
    subnetGroupStatus: Option[String] = None,
    subnets: Option[Iterable[zio.aws.databasemigration.model.Subnet]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.databasemigration.model.ReplicationSubnetGroup = {
    import ReplicationSubnetGroup.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.databasemigration.model.ReplicationSubnetGroup
      .builder()
      .optionallyWith(
        replicationSubnetGroupIdentifier.map(value => value: java.lang.String)
      )(_.replicationSubnetGroupIdentifier)
      .optionallyWith(
        replicationSubnetGroupDescription.map(value => value: java.lang.String)
      )(_.replicationSubnetGroupDescription)
      .optionallyWith(vpcId.map(value => value: java.lang.String))(_.vpcId)
      .optionallyWith(subnetGroupStatus.map(value => value: java.lang.String))(
        _.subnetGroupStatus
      )
      .optionallyWith(
        subnets.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.subnets)
      .build()
  }
  def asReadOnly
      : zio.aws.databasemigration.model.ReplicationSubnetGroup.ReadOnly =
    zio.aws.databasemigration.model.ReplicationSubnetGroup.wrap(buildAwsValue())
}
object ReplicationSubnetGroup {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.databasemigration.model.ReplicationSubnetGroup
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.databasemigration.model.ReplicationSubnetGroup =
      zio.aws.databasemigration.model.ReplicationSubnetGroup(
        replicationSubnetGroupIdentifier.map(value => value),
        replicationSubnetGroupDescription.map(value => value),
        vpcId.map(value => value),
        subnetGroupStatus.map(value => value),
        subnets.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def replicationSubnetGroupIdentifier: Option[String]
    def replicationSubnetGroupDescription: Option[String]
    def vpcId: Option[String]
    def subnetGroupStatus: Option[String]
    def subnets: Option[List[zio.aws.databasemigration.model.Subnet.ReadOnly]]
    def getReplicationSubnetGroupIdentifier: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField(
        "replicationSubnetGroupIdentifier",
        replicationSubnetGroupIdentifier
      )
    def getReplicationSubnetGroupDescription: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField(
        "replicationSubnetGroupDescription",
        replicationSubnetGroupDescription
      )
    def getVpcId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("vpcId", vpcId)
    def getSubnetGroupStatus: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("subnetGroupStatus", subnetGroupStatus)
    def getSubnets: ZIO[Any, AwsError, List[
      zio.aws.databasemigration.model.Subnet.ReadOnly
    ]] = AwsError.unwrapOptionField("subnets", subnets)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.databasemigration.model.ReplicationSubnetGroup
  ) extends zio.aws.databasemigration.model.ReplicationSubnetGroup.ReadOnly {
    override val replicationSubnetGroupIdentifier: Option[String] = scala
      .Option(impl.replicationSubnetGroupIdentifier())
      .map(value => value: String)
    override val replicationSubnetGroupDescription: Option[String] = scala
      .Option(impl.replicationSubnetGroupDescription())
      .map(value => value: String)
    override val vpcId: Option[String] =
      scala.Option(impl.vpcId()).map(value => value: String)
    override val subnetGroupStatus: Option[String] =
      scala.Option(impl.subnetGroupStatus()).map(value => value: String)
    override val subnets
        : Option[List[zio.aws.databasemigration.model.Subnet.ReadOnly]] = scala
      .Option(impl.subnets())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.databasemigration.model.Subnet.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.databasemigration.model.ReplicationSubnetGroup
  ): zio.aws.databasemigration.model.ReplicationSubnetGroup.ReadOnly =
    new Wrapper(impl)
}
