package zio.aws.databasemigration.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ApplyPendingMaintenanceActionResponse(
    resourcePendingMaintenanceActions: Option[
      zio.aws.databasemigration.model.ResourcePendingMaintenanceActions
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.databasemigration.model.ApplyPendingMaintenanceActionResponse = {
    import ApplyPendingMaintenanceActionResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.databasemigration.model.ApplyPendingMaintenanceActionResponse
      .builder()
      .optionallyWith(
        resourcePendingMaintenanceActions.map(value => value.buildAwsValue())
      )(_.resourcePendingMaintenanceActions)
      .build()
  }
  def asReadOnly
      : zio.aws.databasemigration.model.ApplyPendingMaintenanceActionResponse.ReadOnly =
    zio.aws.databasemigration.model.ApplyPendingMaintenanceActionResponse
      .wrap(buildAwsValue())
}
object ApplyPendingMaintenanceActionResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.databasemigration.model.ApplyPendingMaintenanceActionResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.databasemigration.model.ApplyPendingMaintenanceActionResponse =
      zio.aws.databasemigration.model.ApplyPendingMaintenanceActionResponse(
        resourcePendingMaintenanceActions.map(value => value.asEditable)
      )
    def resourcePendingMaintenanceActions: Option[
      zio.aws.databasemigration.model.ResourcePendingMaintenanceActions.ReadOnly
    ]
    def getResourcePendingMaintenanceActions: ZIO[
      Any,
      AwsError,
      zio.aws.databasemigration.model.ResourcePendingMaintenanceActions.ReadOnly
    ] = AwsError.unwrapOptionField(
      "resourcePendingMaintenanceActions",
      resourcePendingMaintenanceActions
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.databasemigration.model.ApplyPendingMaintenanceActionResponse
  ) extends zio.aws.databasemigration.model.ApplyPendingMaintenanceActionResponse.ReadOnly {
    override val resourcePendingMaintenanceActions: Option[
      zio.aws.databasemigration.model.ResourcePendingMaintenanceActions.ReadOnly
    ] = scala
      .Option(impl.resourcePendingMaintenanceActions())
      .map(value =>
        zio.aws.databasemigration.model.ResourcePendingMaintenanceActions
          .wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.databasemigration.model.ApplyPendingMaintenanceActionResponse
  ): zio.aws.databasemigration.model.ApplyPendingMaintenanceActionResponse.ReadOnly =
    new Wrapper(impl)
}
