package zio.aws.databasemigration.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.databasemigration.model.primitives.{
  BooleanOptional,
  IntegerOptional
}
import scala.jdk.CollectionConverters._
final case class ModifyReplicationInstanceRequest(
    replicationInstanceArn: String,
    allocatedStorage: Option[IntegerOptional] = None,
    applyImmediately: Option[Boolean] = None,
    replicationInstanceClass: Option[String] = None,
    vpcSecurityGroupIds: Option[Iterable[String]] = None,
    preferredMaintenanceWindow: Option[String] = None,
    multiAZ: Option[BooleanOptional] = None,
    engineVersion: Option[String] = None,
    allowMajorVersionUpgrade: Option[Boolean] = None,
    autoMinorVersionUpgrade: Option[BooleanOptional] = None,
    replicationInstanceIdentifier: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.databasemigration.model.ModifyReplicationInstanceRequest = {
    import ModifyReplicationInstanceRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.databasemigration.model.ModifyReplicationInstanceRequest
      .builder()
      .replicationInstanceArn(replicationInstanceArn: java.lang.String)
      .optionallyWith(allocatedStorage.map(value => value: Integer))(
        _.allocatedStorage
      )
      .optionallyWith(applyImmediately.map(value => value: java.lang.Boolean))(
        _.applyImmediately
      )
      .optionallyWith(
        replicationInstanceClass.map(value => value: java.lang.String)
      )(_.replicationInstanceClass)
      .optionallyWith(
        vpcSecurityGroupIds.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.vpcSecurityGroupIds)
      .optionallyWith(
        preferredMaintenanceWindow.map(value => value: java.lang.String)
      )(_.preferredMaintenanceWindow)
      .optionallyWith(multiAZ.map(value => value: java.lang.Boolean))(_.multiAZ)
      .optionallyWith(engineVersion.map(value => value: java.lang.String))(
        _.engineVersion
      )
      .optionallyWith(
        allowMajorVersionUpgrade.map(value => value: java.lang.Boolean)
      )(_.allowMajorVersionUpgrade)
      .optionallyWith(
        autoMinorVersionUpgrade.map(value => value: java.lang.Boolean)
      )(_.autoMinorVersionUpgrade)
      .optionallyWith(
        replicationInstanceIdentifier.map(value => value: java.lang.String)
      )(_.replicationInstanceIdentifier)
      .build()
  }
  def asReadOnly
      : zio.aws.databasemigration.model.ModifyReplicationInstanceRequest.ReadOnly =
    zio.aws.databasemigration.model.ModifyReplicationInstanceRequest
      .wrap(buildAwsValue())
}
object ModifyReplicationInstanceRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.databasemigration.model.ModifyReplicationInstanceRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.databasemigration.model.ModifyReplicationInstanceRequest =
      zio.aws.databasemigration.model.ModifyReplicationInstanceRequest(
        replicationInstanceArn,
        allocatedStorage.map(value => value),
        applyImmediately.map(value => value),
        replicationInstanceClass.map(value => value),
        vpcSecurityGroupIds.map(value => value),
        preferredMaintenanceWindow.map(value => value),
        multiAZ.map(value => value),
        engineVersion.map(value => value),
        allowMajorVersionUpgrade.map(value => value),
        autoMinorVersionUpgrade.map(value => value),
        replicationInstanceIdentifier.map(value => value)
      )
    def replicationInstanceArn: String
    def allocatedStorage: Option[IntegerOptional]
    def applyImmediately: Option[Boolean]
    def replicationInstanceClass: Option[String]
    def vpcSecurityGroupIds: Option[List[String]]
    def preferredMaintenanceWindow: Option[String]
    def multiAZ: Option[BooleanOptional]
    def engineVersion: Option[String]
    def allowMajorVersionUpgrade: Option[Boolean]
    def autoMinorVersionUpgrade: Option[BooleanOptional]
    def replicationInstanceIdentifier: Option[String]
    def getReplicationInstanceArn: ZIO[Any, Nothing, String] =
      ZIO.succeed(replicationInstanceArn)
    def getAllocatedStorage: ZIO[Any, AwsError, IntegerOptional] =
      AwsError.unwrapOptionField("allocatedStorage", allocatedStorage)
    def getApplyImmediately: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("applyImmediately", applyImmediately)
    def getReplicationInstanceClass: ZIO[Any, AwsError, String] = AwsError
      .unwrapOptionField("replicationInstanceClass", replicationInstanceClass)
    def getVpcSecurityGroupIds: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("vpcSecurityGroupIds", vpcSecurityGroupIds)
    def getPreferredMaintenanceWindow: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField(
        "preferredMaintenanceWindow",
        preferredMaintenanceWindow
      )
    def getMultiAZ: ZIO[Any, AwsError, BooleanOptional] =
      AwsError.unwrapOptionField("multiAZ", multiAZ)
    def getEngineVersion: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("engineVersion", engineVersion)
    def getAllowMajorVersionUpgrade: ZIO[Any, AwsError, Boolean] = AwsError
      .unwrapOptionField("allowMajorVersionUpgrade", allowMajorVersionUpgrade)
    def getAutoMinorVersionUpgrade: ZIO[Any, AwsError, BooleanOptional] =
      AwsError.unwrapOptionField(
        "autoMinorVersionUpgrade",
        autoMinorVersionUpgrade
      )
    def getReplicationInstanceIdentifier: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField(
        "replicationInstanceIdentifier",
        replicationInstanceIdentifier
      )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.databasemigration.model.ModifyReplicationInstanceRequest
  ) extends zio.aws.databasemigration.model.ModifyReplicationInstanceRequest.ReadOnly {
    override val replicationInstanceArn: String =
      impl.replicationInstanceArn(): String
    override val allocatedStorage: Option[IntegerOptional] =
      scala.Option(impl.allocatedStorage()).map(value => value: IntegerOptional)
    override val applyImmediately: Option[Boolean] =
      scala.Option(impl.applyImmediately()).map(value => value: Boolean)
    override val replicationInstanceClass: Option[String] =
      scala.Option(impl.replicationInstanceClass()).map(value => value: String)
    override val vpcSecurityGroupIds: Option[List[String]] = scala
      .Option(impl.vpcSecurityGroupIds())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
    override val preferredMaintenanceWindow: Option[String] = scala
      .Option(impl.preferredMaintenanceWindow())
      .map(value => value: String)
    override val multiAZ: Option[BooleanOptional] =
      scala.Option(impl.multiAZ()).map(value => value: BooleanOptional)
    override val engineVersion: Option[String] =
      scala.Option(impl.engineVersion()).map(value => value: String)
    override val allowMajorVersionUpgrade: Option[Boolean] =
      scala.Option(impl.allowMajorVersionUpgrade()).map(value => value: Boolean)
    override val autoMinorVersionUpgrade: Option[BooleanOptional] = scala
      .Option(impl.autoMinorVersionUpgrade())
      .map(value => value: BooleanOptional)
    override val replicationInstanceIdentifier: Option[String] = scala
      .Option(impl.replicationInstanceIdentifier())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.databasemigration.model.ModifyReplicationInstanceRequest
  ): zio.aws.databasemigration.model.ModifyReplicationInstanceRequest.ReadOnly =
    new Wrapper(impl)
}
