package zio.aws.databasemigration.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.databasemigration.model.primitives.{
  IntegerOptional,
  SecretString
}
import scala.jdk.CollectionConverters._
final case class CreateEndpointRequest(
    endpointIdentifier: String,
    endpointType: zio.aws.databasemigration.model.ReplicationEndpointTypeValue,
    engineName: String,
    username: Option[String] = None,
    password: Option[SecretString] = None,
    serverName: Option[String] = None,
    port: Option[IntegerOptional] = None,
    databaseName: Option[String] = None,
    extraConnectionAttributes: Option[String] = None,
    kmsKeyId: Option[String] = None,
    tags: Option[Iterable[zio.aws.databasemigration.model.Tag]] = None,
    certificateArn: Option[String] = None,
    sslMode: Option[zio.aws.databasemigration.model.DmsSslModeValue] = None,
    serviceAccessRoleArn: Option[String] = None,
    externalTableDefinition: Option[String] = None,
    dynamoDbSettings: Option[zio.aws.databasemigration.model.DynamoDbSettings] =
      None,
    s3Settings: Option[zio.aws.databasemigration.model.S3Settings] = None,
    dmsTransferSettings: Option[
      zio.aws.databasemigration.model.DmsTransferSettings
    ] = None,
    mongoDbSettings: Option[zio.aws.databasemigration.model.MongoDbSettings] =
      None,
    kinesisSettings: Option[zio.aws.databasemigration.model.KinesisSettings] =
      None,
    kafkaSettings: Option[zio.aws.databasemigration.model.KafkaSettings] = None,
    elasticsearchSettings: Option[
      zio.aws.databasemigration.model.ElasticsearchSettings
    ] = None,
    neptuneSettings: Option[zio.aws.databasemigration.model.NeptuneSettings] =
      None,
    redshiftSettings: Option[zio.aws.databasemigration.model.RedshiftSettings] =
      None,
    postgreSQLSettings: Option[
      zio.aws.databasemigration.model.PostgreSQLSettings
    ] = None,
    mySQLSettings: Option[zio.aws.databasemigration.model.MySQLSettings] = None,
    oracleSettings: Option[zio.aws.databasemigration.model.OracleSettings] =
      None,
    sybaseSettings: Option[zio.aws.databasemigration.model.SybaseSettings] =
      None,
    microsoftSQLServerSettings: Option[
      zio.aws.databasemigration.model.MicrosoftSQLServerSettings
    ] = None,
    ibmDb2Settings: Option[zio.aws.databasemigration.model.IBMDb2Settings] =
      None,
    resourceIdentifier: Option[String] = None,
    docDbSettings: Option[zio.aws.databasemigration.model.DocDbSettings] = None,
    redisSettings: Option[zio.aws.databasemigration.model.RedisSettings] = None,
    gcpMySQLSettings: Option[zio.aws.databasemigration.model.GcpMySQLSettings] =
      None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.databasemigration.model.CreateEndpointRequest = {
    import CreateEndpointRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.databasemigration.model.CreateEndpointRequest
      .builder()
      .endpointIdentifier(endpointIdentifier: java.lang.String)
      .endpointType(endpointType.unwrap)
      .engineName(engineName: java.lang.String)
      .optionallyWith(username.map(value => value: java.lang.String))(
        _.username
      )
      .optionallyWith(
        password.map(value => SecretString.unwrap(value): java.lang.String)
      )(_.password)
      .optionallyWith(serverName.map(value => value: java.lang.String))(
        _.serverName
      )
      .optionallyWith(port.map(value => value: Integer))(_.port)
      .optionallyWith(databaseName.map(value => value: java.lang.String))(
        _.databaseName
      )
      .optionallyWith(
        extraConnectionAttributes.map(value => value: java.lang.String)
      )(_.extraConnectionAttributes)
      .optionallyWith(kmsKeyId.map(value => value: java.lang.String))(
        _.kmsKeyId
      )
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .optionallyWith(certificateArn.map(value => value: java.lang.String))(
        _.certificateArn
      )
      .optionallyWith(sslMode.map(value => value.unwrap))(_.sslMode)
      .optionallyWith(
        serviceAccessRoleArn.map(value => value: java.lang.String)
      )(_.serviceAccessRoleArn)
      .optionallyWith(
        externalTableDefinition.map(value => value: java.lang.String)
      )(_.externalTableDefinition)
      .optionallyWith(dynamoDbSettings.map(value => value.buildAwsValue()))(
        _.dynamoDbSettings
      )
      .optionallyWith(s3Settings.map(value => value.buildAwsValue()))(
        _.s3Settings
      )
      .optionallyWith(dmsTransferSettings.map(value => value.buildAwsValue()))(
        _.dmsTransferSettings
      )
      .optionallyWith(mongoDbSettings.map(value => value.buildAwsValue()))(
        _.mongoDbSettings
      )
      .optionallyWith(kinesisSettings.map(value => value.buildAwsValue()))(
        _.kinesisSettings
      )
      .optionallyWith(kafkaSettings.map(value => value.buildAwsValue()))(
        _.kafkaSettings
      )
      .optionallyWith(
        elasticsearchSettings.map(value => value.buildAwsValue())
      )(_.elasticsearchSettings)
      .optionallyWith(neptuneSettings.map(value => value.buildAwsValue()))(
        _.neptuneSettings
      )
      .optionallyWith(redshiftSettings.map(value => value.buildAwsValue()))(
        _.redshiftSettings
      )
      .optionallyWith(postgreSQLSettings.map(value => value.buildAwsValue()))(
        _.postgreSQLSettings
      )
      .optionallyWith(mySQLSettings.map(value => value.buildAwsValue()))(
        _.mySQLSettings
      )
      .optionallyWith(oracleSettings.map(value => value.buildAwsValue()))(
        _.oracleSettings
      )
      .optionallyWith(sybaseSettings.map(value => value.buildAwsValue()))(
        _.sybaseSettings
      )
      .optionallyWith(
        microsoftSQLServerSettings.map(value => value.buildAwsValue())
      )(_.microsoftSQLServerSettings)
      .optionallyWith(ibmDb2Settings.map(value => value.buildAwsValue()))(
        _.ibmDb2Settings
      )
      .optionallyWith(resourceIdentifier.map(value => value: java.lang.String))(
        _.resourceIdentifier
      )
      .optionallyWith(docDbSettings.map(value => value.buildAwsValue()))(
        _.docDbSettings
      )
      .optionallyWith(redisSettings.map(value => value.buildAwsValue()))(
        _.redisSettings
      )
      .optionallyWith(gcpMySQLSettings.map(value => value.buildAwsValue()))(
        _.gcpMySQLSettings
      )
      .build()
  }
  def asReadOnly
      : zio.aws.databasemigration.model.CreateEndpointRequest.ReadOnly =
    zio.aws.databasemigration.model.CreateEndpointRequest.wrap(buildAwsValue())
}
object CreateEndpointRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.databasemigration.model.CreateEndpointRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.databasemigration.model.CreateEndpointRequest =
      zio.aws.databasemigration.model.CreateEndpointRequest(
        endpointIdentifier,
        endpointType,
        engineName,
        username.map(value => value),
        password.map(value => value),
        serverName.map(value => value),
        port.map(value => value),
        databaseName.map(value => value),
        extraConnectionAttributes.map(value => value),
        kmsKeyId.map(value => value),
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        certificateArn.map(value => value),
        sslMode.map(value => value),
        serviceAccessRoleArn.map(value => value),
        externalTableDefinition.map(value => value),
        dynamoDbSettings.map(value => value.asEditable),
        s3Settings.map(value => value.asEditable),
        dmsTransferSettings.map(value => value.asEditable),
        mongoDbSettings.map(value => value.asEditable),
        kinesisSettings.map(value => value.asEditable),
        kafkaSettings.map(value => value.asEditable),
        elasticsearchSettings.map(value => value.asEditable),
        neptuneSettings.map(value => value.asEditable),
        redshiftSettings.map(value => value.asEditable),
        postgreSQLSettings.map(value => value.asEditable),
        mySQLSettings.map(value => value.asEditable),
        oracleSettings.map(value => value.asEditable),
        sybaseSettings.map(value => value.asEditable),
        microsoftSQLServerSettings.map(value => value.asEditable),
        ibmDb2Settings.map(value => value.asEditable),
        resourceIdentifier.map(value => value),
        docDbSettings.map(value => value.asEditable),
        redisSettings.map(value => value.asEditable),
        gcpMySQLSettings.map(value => value.asEditable)
      )
    def endpointIdentifier: String
    def endpointType
        : zio.aws.databasemigration.model.ReplicationEndpointTypeValue
    def engineName: String
    def username: Option[String]
    def password: Option[SecretString]
    def serverName: Option[String]
    def port: Option[IntegerOptional]
    def databaseName: Option[String]
    def extraConnectionAttributes: Option[String]
    def kmsKeyId: Option[String]
    def tags: Option[List[zio.aws.databasemigration.model.Tag.ReadOnly]]
    def certificateArn: Option[String]
    def sslMode: Option[zio.aws.databasemigration.model.DmsSslModeValue]
    def serviceAccessRoleArn: Option[String]
    def externalTableDefinition: Option[String]
    def dynamoDbSettings
        : Option[zio.aws.databasemigration.model.DynamoDbSettings.ReadOnly]
    def s3Settings: Option[zio.aws.databasemigration.model.S3Settings.ReadOnly]
    def dmsTransferSettings
        : Option[zio.aws.databasemigration.model.DmsTransferSettings.ReadOnly]
    def mongoDbSettings
        : Option[zio.aws.databasemigration.model.MongoDbSettings.ReadOnly]
    def kinesisSettings
        : Option[zio.aws.databasemigration.model.KinesisSettings.ReadOnly]
    def kafkaSettings
        : Option[zio.aws.databasemigration.model.KafkaSettings.ReadOnly]
    def elasticsearchSettings
        : Option[zio.aws.databasemigration.model.ElasticsearchSettings.ReadOnly]
    def neptuneSettings
        : Option[zio.aws.databasemigration.model.NeptuneSettings.ReadOnly]
    def redshiftSettings
        : Option[zio.aws.databasemigration.model.RedshiftSettings.ReadOnly]
    def postgreSQLSettings
        : Option[zio.aws.databasemigration.model.PostgreSQLSettings.ReadOnly]
    def mySQLSettings
        : Option[zio.aws.databasemigration.model.MySQLSettings.ReadOnly]
    def oracleSettings
        : Option[zio.aws.databasemigration.model.OracleSettings.ReadOnly]
    def sybaseSettings
        : Option[zio.aws.databasemigration.model.SybaseSettings.ReadOnly]
    def microsoftSQLServerSettings: Option[
      zio.aws.databasemigration.model.MicrosoftSQLServerSettings.ReadOnly
    ]
    def ibmDb2Settings
        : Option[zio.aws.databasemigration.model.IBMDb2Settings.ReadOnly]
    def resourceIdentifier: Option[String]
    def docDbSettings
        : Option[zio.aws.databasemigration.model.DocDbSettings.ReadOnly]
    def redisSettings
        : Option[zio.aws.databasemigration.model.RedisSettings.ReadOnly]
    def gcpMySQLSettings
        : Option[zio.aws.databasemigration.model.GcpMySQLSettings.ReadOnly]
    def getEndpointIdentifier: ZIO[Any, Nothing, String] =
      ZIO.succeed(endpointIdentifier)
    def getEndpointType: ZIO[
      Any,
      Nothing,
      zio.aws.databasemigration.model.ReplicationEndpointTypeValue
    ] = ZIO.succeed(endpointType)
    def getEngineName: ZIO[Any, Nothing, String] = ZIO.succeed(engineName)
    def getUsername: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("username", username)
    def getPassword: ZIO[Any, AwsError, SecretString] =
      AwsError.unwrapOptionField("password", password)
    def getServerName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("serverName", serverName)
    def getPort: ZIO[Any, AwsError, IntegerOptional] =
      AwsError.unwrapOptionField("port", port)
    def getDatabaseName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("databaseName", databaseName)
    def getExtraConnectionAttributes: ZIO[Any, AwsError, String] = AwsError
      .unwrapOptionField("extraConnectionAttributes", extraConnectionAttributes)
    def getKmsKeyId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("kmsKeyId", kmsKeyId)
    def getTags: ZIO[Any, AwsError, List[
      zio.aws.databasemigration.model.Tag.ReadOnly
    ]] = AwsError.unwrapOptionField("tags", tags)
    def getCertificateArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("certificateArn", certificateArn)
    def getSslMode
        : ZIO[Any, AwsError, zio.aws.databasemigration.model.DmsSslModeValue] =
      AwsError.unwrapOptionField("sslMode", sslMode)
    def getServiceAccessRoleArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("serviceAccessRoleArn", serviceAccessRoleArn)
    def getExternalTableDefinition: ZIO[Any, AwsError, String] = AwsError
      .unwrapOptionField("externalTableDefinition", externalTableDefinition)
    def getDynamoDbSettings: ZIO[
      Any,
      AwsError,
      zio.aws.databasemigration.model.DynamoDbSettings.ReadOnly
    ] = AwsError.unwrapOptionField("dynamoDbSettings", dynamoDbSettings)
    def getS3Settings: ZIO[
      Any,
      AwsError,
      zio.aws.databasemigration.model.S3Settings.ReadOnly
    ] = AwsError.unwrapOptionField("s3Settings", s3Settings)
    def getDmsTransferSettings: ZIO[
      Any,
      AwsError,
      zio.aws.databasemigration.model.DmsTransferSettings.ReadOnly
    ] = AwsError.unwrapOptionField("dmsTransferSettings", dmsTransferSettings)
    def getMongoDbSettings: ZIO[
      Any,
      AwsError,
      zio.aws.databasemigration.model.MongoDbSettings.ReadOnly
    ] = AwsError.unwrapOptionField("mongoDbSettings", mongoDbSettings)
    def getKinesisSettings: ZIO[
      Any,
      AwsError,
      zio.aws.databasemigration.model.KinesisSettings.ReadOnly
    ] = AwsError.unwrapOptionField("kinesisSettings", kinesisSettings)
    def getKafkaSettings: ZIO[
      Any,
      AwsError,
      zio.aws.databasemigration.model.KafkaSettings.ReadOnly
    ] = AwsError.unwrapOptionField("kafkaSettings", kafkaSettings)
    def getElasticsearchSettings: ZIO[
      Any,
      AwsError,
      zio.aws.databasemigration.model.ElasticsearchSettings.ReadOnly
    ] =
      AwsError.unwrapOptionField("elasticsearchSettings", elasticsearchSettings)
    def getNeptuneSettings: ZIO[
      Any,
      AwsError,
      zio.aws.databasemigration.model.NeptuneSettings.ReadOnly
    ] = AwsError.unwrapOptionField("neptuneSettings", neptuneSettings)
    def getRedshiftSettings: ZIO[
      Any,
      AwsError,
      zio.aws.databasemigration.model.RedshiftSettings.ReadOnly
    ] = AwsError.unwrapOptionField("redshiftSettings", redshiftSettings)
    def getPostgreSQLSettings: ZIO[
      Any,
      AwsError,
      zio.aws.databasemigration.model.PostgreSQLSettings.ReadOnly
    ] = AwsError.unwrapOptionField("postgreSQLSettings", postgreSQLSettings)
    def getMySQLSettings: ZIO[
      Any,
      AwsError,
      zio.aws.databasemigration.model.MySQLSettings.ReadOnly
    ] = AwsError.unwrapOptionField("mySQLSettings", mySQLSettings)
    def getOracleSettings: ZIO[
      Any,
      AwsError,
      zio.aws.databasemigration.model.OracleSettings.ReadOnly
    ] = AwsError.unwrapOptionField("oracleSettings", oracleSettings)
    def getSybaseSettings: ZIO[
      Any,
      AwsError,
      zio.aws.databasemigration.model.SybaseSettings.ReadOnly
    ] = AwsError.unwrapOptionField("sybaseSettings", sybaseSettings)
    def getMicrosoftSQLServerSettings: ZIO[
      Any,
      AwsError,
      zio.aws.databasemigration.model.MicrosoftSQLServerSettings.ReadOnly
    ] = AwsError.unwrapOptionField(
      "microsoftSQLServerSettings",
      microsoftSQLServerSettings
    )
    def getIbmDb2Settings: ZIO[
      Any,
      AwsError,
      zio.aws.databasemigration.model.IBMDb2Settings.ReadOnly
    ] = AwsError.unwrapOptionField("ibmDb2Settings", ibmDb2Settings)
    def getResourceIdentifier: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("resourceIdentifier", resourceIdentifier)
    def getDocDbSettings: ZIO[
      Any,
      AwsError,
      zio.aws.databasemigration.model.DocDbSettings.ReadOnly
    ] = AwsError.unwrapOptionField("docDbSettings", docDbSettings)
    def getRedisSettings: ZIO[
      Any,
      AwsError,
      zio.aws.databasemigration.model.RedisSettings.ReadOnly
    ] = AwsError.unwrapOptionField("redisSettings", redisSettings)
    def getGcpMySQLSettings: ZIO[
      Any,
      AwsError,
      zio.aws.databasemigration.model.GcpMySQLSettings.ReadOnly
    ] = AwsError.unwrapOptionField("gcpMySQLSettings", gcpMySQLSettings)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.databasemigration.model.CreateEndpointRequest
  ) extends zio.aws.databasemigration.model.CreateEndpointRequest.ReadOnly {
    override val endpointIdentifier: String = impl.endpointIdentifier(): String
    override val endpointType
        : zio.aws.databasemigration.model.ReplicationEndpointTypeValue =
      zio.aws.databasemigration.model.ReplicationEndpointTypeValue
        .wrap(impl.endpointType())
    override val engineName: String = impl.engineName(): String
    override val username: Option[String] =
      scala.Option(impl.username()).map(value => value: String)
    override val password: Option[SecretString] = scala
      .Option(impl.password())
      .map(value =>
        zio.aws.databasemigration.model.primitives.SecretString(value)
      )
    override val serverName: Option[String] =
      scala.Option(impl.serverName()).map(value => value: String)
    override val port: Option[IntegerOptional] =
      scala.Option(impl.port()).map(value => value: IntegerOptional)
    override val databaseName: Option[String] =
      scala.Option(impl.databaseName()).map(value => value: String)
    override val extraConnectionAttributes: Option[String] =
      scala.Option(impl.extraConnectionAttributes()).map(value => value: String)
    override val kmsKeyId: Option[String] =
      scala.Option(impl.kmsKeyId()).map(value => value: String)
    override val tags
        : Option[List[zio.aws.databasemigration.model.Tag.ReadOnly]] = scala
      .Option(impl.tags())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.databasemigration.model.Tag.wrap(item)
        }.toList
      )
    override val certificateArn: Option[String] =
      scala.Option(impl.certificateArn()).map(value => value: String)
    override val sslMode
        : Option[zio.aws.databasemigration.model.DmsSslModeValue] = scala
      .Option(impl.sslMode())
      .map(value => zio.aws.databasemigration.model.DmsSslModeValue.wrap(value))
    override val serviceAccessRoleArn: Option[String] =
      scala.Option(impl.serviceAccessRoleArn()).map(value => value: String)
    override val externalTableDefinition: Option[String] =
      scala.Option(impl.externalTableDefinition()).map(value => value: String)
    override val dynamoDbSettings
        : Option[zio.aws.databasemigration.model.DynamoDbSettings.ReadOnly] =
      scala
        .Option(impl.dynamoDbSettings())
        .map(value =>
          zio.aws.databasemigration.model.DynamoDbSettings.wrap(value)
        )
    override val s3Settings
        : Option[zio.aws.databasemigration.model.S3Settings.ReadOnly] = scala
      .Option(impl.s3Settings())
      .map(value => zio.aws.databasemigration.model.S3Settings.wrap(value))
    override val dmsTransferSettings
        : Option[zio.aws.databasemigration.model.DmsTransferSettings.ReadOnly] =
      scala
        .Option(impl.dmsTransferSettings())
        .map(value =>
          zio.aws.databasemigration.model.DmsTransferSettings.wrap(value)
        )
    override val mongoDbSettings
        : Option[zio.aws.databasemigration.model.MongoDbSettings.ReadOnly] =
      scala
        .Option(impl.mongoDbSettings())
        .map(value =>
          zio.aws.databasemigration.model.MongoDbSettings.wrap(value)
        )
    override val kinesisSettings
        : Option[zio.aws.databasemigration.model.KinesisSettings.ReadOnly] =
      scala
        .Option(impl.kinesisSettings())
        .map(value =>
          zio.aws.databasemigration.model.KinesisSettings.wrap(value)
        )
    override val kafkaSettings
        : Option[zio.aws.databasemigration.model.KafkaSettings.ReadOnly] = scala
      .Option(impl.kafkaSettings())
      .map(value => zio.aws.databasemigration.model.KafkaSettings.wrap(value))
    override val elasticsearchSettings: Option[
      zio.aws.databasemigration.model.ElasticsearchSettings.ReadOnly
    ] = scala
      .Option(impl.elasticsearchSettings())
      .map(value =>
        zio.aws.databasemigration.model.ElasticsearchSettings.wrap(value)
      )
    override val neptuneSettings
        : Option[zio.aws.databasemigration.model.NeptuneSettings.ReadOnly] =
      scala
        .Option(impl.neptuneSettings())
        .map(value =>
          zio.aws.databasemigration.model.NeptuneSettings.wrap(value)
        )
    override val redshiftSettings
        : Option[zio.aws.databasemigration.model.RedshiftSettings.ReadOnly] =
      scala
        .Option(impl.redshiftSettings())
        .map(value =>
          zio.aws.databasemigration.model.RedshiftSettings.wrap(value)
        )
    override val postgreSQLSettings
        : Option[zio.aws.databasemigration.model.PostgreSQLSettings.ReadOnly] =
      scala
        .Option(impl.postgreSQLSettings())
        .map(value =>
          zio.aws.databasemigration.model.PostgreSQLSettings.wrap(value)
        )
    override val mySQLSettings
        : Option[zio.aws.databasemigration.model.MySQLSettings.ReadOnly] = scala
      .Option(impl.mySQLSettings())
      .map(value => zio.aws.databasemigration.model.MySQLSettings.wrap(value))
    override val oracleSettings
        : Option[zio.aws.databasemigration.model.OracleSettings.ReadOnly] =
      scala
        .Option(impl.oracleSettings())
        .map(value =>
          zio.aws.databasemigration.model.OracleSettings.wrap(value)
        )
    override val sybaseSettings
        : Option[zio.aws.databasemigration.model.SybaseSettings.ReadOnly] =
      scala
        .Option(impl.sybaseSettings())
        .map(value =>
          zio.aws.databasemigration.model.SybaseSettings.wrap(value)
        )
    override val microsoftSQLServerSettings: Option[
      zio.aws.databasemigration.model.MicrosoftSQLServerSettings.ReadOnly
    ] = scala
      .Option(impl.microsoftSQLServerSettings())
      .map(value =>
        zio.aws.databasemigration.model.MicrosoftSQLServerSettings.wrap(value)
      )
    override val ibmDb2Settings
        : Option[zio.aws.databasemigration.model.IBMDb2Settings.ReadOnly] =
      scala
        .Option(impl.ibmDb2Settings())
        .map(value =>
          zio.aws.databasemigration.model.IBMDb2Settings.wrap(value)
        )
    override val resourceIdentifier: Option[String] =
      scala.Option(impl.resourceIdentifier()).map(value => value: String)
    override val docDbSettings
        : Option[zio.aws.databasemigration.model.DocDbSettings.ReadOnly] = scala
      .Option(impl.docDbSettings())
      .map(value => zio.aws.databasemigration.model.DocDbSettings.wrap(value))
    override val redisSettings
        : Option[zio.aws.databasemigration.model.RedisSettings.ReadOnly] = scala
      .Option(impl.redisSettings())
      .map(value => zio.aws.databasemigration.model.RedisSettings.wrap(value))
    override val gcpMySQLSettings
        : Option[zio.aws.databasemigration.model.GcpMySQLSettings.ReadOnly] =
      scala
        .Option(impl.gcpMySQLSettings())
        .map(value =>
          zio.aws.databasemigration.model.GcpMySQLSettings.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.databasemigration.model.CreateEndpointRequest
  ): zio.aws.databasemigration.model.CreateEndpointRequest.ReadOnly =
    new Wrapper(impl)
}
