package zio.aws.databasemigration.model
import scala.jdk.CollectionConverters._
sealed trait TargetDbType {
  def unwrap
      : software.amazon.awssdk.services.databasemigration.model.TargetDbType
}
object TargetDbType {
  def wrap(
      value: software.amazon.awssdk.services.databasemigration.model.TargetDbType
  ): zio.aws.databasemigration.model.TargetDbType = value match {
    case software.amazon.awssdk.services.databasemigration.model.TargetDbType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.databasemigration.model.TargetDbType.SPECIFIC_DATABASE =>
      val r = `specific-database`
      r
    case software.amazon.awssdk.services.databasemigration.model.TargetDbType.MULTIPLE_DATABASES =>
      val r = `multiple-databases`
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.databasemigration.model.TargetDbType {
    override def unwrap
        : software.amazon.awssdk.services.databasemigration.model.TargetDbType =
      software.amazon.awssdk.services.databasemigration.model.TargetDbType.UNKNOWN_TO_SDK_VERSION
  }
  case object `specific-database`
      extends zio.aws.databasemigration.model.TargetDbType {
    override def unwrap
        : software.amazon.awssdk.services.databasemigration.model.TargetDbType =
      software.amazon.awssdk.services.databasemigration.model.TargetDbType.SPECIFIC_DATABASE
  }
  case object `multiple-databases`
      extends zio.aws.databasemigration.model.TargetDbType {
    override def unwrap
        : software.amazon.awssdk.services.databasemigration.model.TargetDbType =
      software.amazon.awssdk.services.databasemigration.model.TargetDbType.MULTIPLE_DATABASES
  }
}
