package zio.aws.databasemigration.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import zio.aws.databasemigration.model.primitives.TStamp
import scala.jdk.CollectionConverters._
final case class ReplicationTaskAssessmentRun(
    replicationTaskAssessmentRunArn: Option[String] = None,
    replicationTaskArn: Option[String] = None,
    status: Option[String] = None,
    replicationTaskAssessmentRunCreationDate: Option[TStamp] = None,
    assessmentProgress: Option[
      zio.aws.databasemigration.model.ReplicationTaskAssessmentRunProgress
    ] = None,
    lastFailureMessage: Option[String] = None,
    serviceAccessRoleArn: Option[String] = None,
    resultLocationBucket: Option[String] = None,
    resultLocationFolder: Option[String] = None,
    resultEncryptionMode: Option[String] = None,
    resultKmsKeyArn: Option[String] = None,
    assessmentRunName: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.databasemigration.model.ReplicationTaskAssessmentRun = {
    import ReplicationTaskAssessmentRun.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.databasemigration.model.ReplicationTaskAssessmentRun
      .builder()
      .optionallyWith(
        replicationTaskAssessmentRunArn.map(value => value: java.lang.String)
      )(_.replicationTaskAssessmentRunArn)
      .optionallyWith(replicationTaskArn.map(value => value: java.lang.String))(
        _.replicationTaskArn
      )
      .optionallyWith(status.map(value => value: java.lang.String))(_.status)
      .optionallyWith(
        replicationTaskAssessmentRunCreationDate.map(value =>
          TStamp.unwrap(value): Instant
        )
      )(_.replicationTaskAssessmentRunCreationDate)
      .optionallyWith(assessmentProgress.map(value => value.buildAwsValue()))(
        _.assessmentProgress
      )
      .optionallyWith(lastFailureMessage.map(value => value: java.lang.String))(
        _.lastFailureMessage
      )
      .optionallyWith(
        serviceAccessRoleArn.map(value => value: java.lang.String)
      )(_.serviceAccessRoleArn)
      .optionallyWith(
        resultLocationBucket.map(value => value: java.lang.String)
      )(_.resultLocationBucket)
      .optionallyWith(
        resultLocationFolder.map(value => value: java.lang.String)
      )(_.resultLocationFolder)
      .optionallyWith(
        resultEncryptionMode.map(value => value: java.lang.String)
      )(_.resultEncryptionMode)
      .optionallyWith(resultKmsKeyArn.map(value => value: java.lang.String))(
        _.resultKmsKeyArn
      )
      .optionallyWith(assessmentRunName.map(value => value: java.lang.String))(
        _.assessmentRunName
      )
      .build()
  }
  def asReadOnly
      : zio.aws.databasemigration.model.ReplicationTaskAssessmentRun.ReadOnly =
    zio.aws.databasemigration.model.ReplicationTaskAssessmentRun
      .wrap(buildAwsValue())
}
object ReplicationTaskAssessmentRun {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.databasemigration.model.ReplicationTaskAssessmentRun
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.databasemigration.model.ReplicationTaskAssessmentRun =
      zio.aws.databasemigration.model.ReplicationTaskAssessmentRun(
        replicationTaskAssessmentRunArn.map(value => value),
        replicationTaskArn.map(value => value),
        status.map(value => value),
        replicationTaskAssessmentRunCreationDate.map(value => value),
        assessmentProgress.map(value => value.asEditable),
        lastFailureMessage.map(value => value),
        serviceAccessRoleArn.map(value => value),
        resultLocationBucket.map(value => value),
        resultLocationFolder.map(value => value),
        resultEncryptionMode.map(value => value),
        resultKmsKeyArn.map(value => value),
        assessmentRunName.map(value => value)
      )
    def replicationTaskAssessmentRunArn: Option[String]
    def replicationTaskArn: Option[String]
    def status: Option[String]
    def replicationTaskAssessmentRunCreationDate: Option[TStamp]
    def assessmentProgress: Option[
      zio.aws.databasemigration.model.ReplicationTaskAssessmentRunProgress.ReadOnly
    ]
    def lastFailureMessage: Option[String]
    def serviceAccessRoleArn: Option[String]
    def resultLocationBucket: Option[String]
    def resultLocationFolder: Option[String]
    def resultEncryptionMode: Option[String]
    def resultKmsKeyArn: Option[String]
    def assessmentRunName: Option[String]
    def getReplicationTaskAssessmentRunArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField(
        "replicationTaskAssessmentRunArn",
        replicationTaskAssessmentRunArn
      )
    def getReplicationTaskArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("replicationTaskArn", replicationTaskArn)
    def getStatus: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("status", status)
    def getReplicationTaskAssessmentRunCreationDate
        : ZIO[Any, AwsError, TStamp] = AwsError.unwrapOptionField(
      "replicationTaskAssessmentRunCreationDate",
      replicationTaskAssessmentRunCreationDate
    )
    def getAssessmentProgress: ZIO[
      Any,
      AwsError,
      zio.aws.databasemigration.model.ReplicationTaskAssessmentRunProgress.ReadOnly
    ] = AwsError.unwrapOptionField("assessmentProgress", assessmentProgress)
    def getLastFailureMessage: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("lastFailureMessage", lastFailureMessage)
    def getServiceAccessRoleArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("serviceAccessRoleArn", serviceAccessRoleArn)
    def getResultLocationBucket: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("resultLocationBucket", resultLocationBucket)
    def getResultLocationFolder: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("resultLocationFolder", resultLocationFolder)
    def getResultEncryptionMode: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("resultEncryptionMode", resultEncryptionMode)
    def getResultKmsKeyArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("resultKmsKeyArn", resultKmsKeyArn)
    def getAssessmentRunName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("assessmentRunName", assessmentRunName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.databasemigration.model.ReplicationTaskAssessmentRun
  ) extends zio.aws.databasemigration.model.ReplicationTaskAssessmentRun.ReadOnly {
    override val replicationTaskAssessmentRunArn: Option[String] = scala
      .Option(impl.replicationTaskAssessmentRunArn())
      .map(value => value: String)
    override val replicationTaskArn: Option[String] =
      scala.Option(impl.replicationTaskArn()).map(value => value: String)
    override val status: Option[String] =
      scala.Option(impl.status()).map(value => value: String)
    override val replicationTaskAssessmentRunCreationDate: Option[TStamp] =
      scala
        .Option(impl.replicationTaskAssessmentRunCreationDate())
        .map(value => zio.aws.databasemigration.model.primitives.TStamp(value))
    override val assessmentProgress: Option[
      zio.aws.databasemigration.model.ReplicationTaskAssessmentRunProgress.ReadOnly
    ] = scala
      .Option(impl.assessmentProgress())
      .map(value =>
        zio.aws.databasemigration.model.ReplicationTaskAssessmentRunProgress
          .wrap(value)
      )
    override val lastFailureMessage: Option[String] =
      scala.Option(impl.lastFailureMessage()).map(value => value: String)
    override val serviceAccessRoleArn: Option[String] =
      scala.Option(impl.serviceAccessRoleArn()).map(value => value: String)
    override val resultLocationBucket: Option[String] =
      scala.Option(impl.resultLocationBucket()).map(value => value: String)
    override val resultLocationFolder: Option[String] =
      scala.Option(impl.resultLocationFolder()).map(value => value: String)
    override val resultEncryptionMode: Option[String] =
      scala.Option(impl.resultEncryptionMode()).map(value => value: String)
    override val resultKmsKeyArn: Option[String] =
      scala.Option(impl.resultKmsKeyArn()).map(value => value: String)
    override val assessmentRunName: Option[String] =
      scala.Option(impl.assessmentRunName()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.databasemigration.model.ReplicationTaskAssessmentRun
  ): zio.aws.databasemigration.model.ReplicationTaskAssessmentRun.ReadOnly =
    new Wrapper(impl)
}
