package zio.aws.databasemigration.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.databasemigration.model.primitives.{
  BooleanOptional,
  IntegerOptional
}
import scala.jdk.CollectionConverters._
final case class NeptuneSettings(
    serviceAccessRoleArn: Option[String] = None,
    s3BucketName: String,
    s3BucketFolder: String,
    errorRetryDuration: Option[IntegerOptional] = None,
    maxFileSize: Option[IntegerOptional] = None,
    maxRetryCount: Option[IntegerOptional] = None,
    iamAuthEnabled: Option[BooleanOptional] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.databasemigration.model.NeptuneSettings = {
    import NeptuneSettings.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.databasemigration.model.NeptuneSettings
      .builder()
      .optionallyWith(
        serviceAccessRoleArn.map(value => value: java.lang.String)
      )(_.serviceAccessRoleArn)
      .s3BucketName(s3BucketName: java.lang.String)
      .s3BucketFolder(s3BucketFolder: java.lang.String)
      .optionallyWith(errorRetryDuration.map(value => value: Integer))(
        _.errorRetryDuration
      )
      .optionallyWith(maxFileSize.map(value => value: Integer))(_.maxFileSize)
      .optionallyWith(maxRetryCount.map(value => value: Integer))(
        _.maxRetryCount
      )
      .optionallyWith(iamAuthEnabled.map(value => value: java.lang.Boolean))(
        _.iamAuthEnabled
      )
      .build()
  }
  def asReadOnly: zio.aws.databasemigration.model.NeptuneSettings.ReadOnly =
    zio.aws.databasemigration.model.NeptuneSettings.wrap(buildAwsValue())
}
object NeptuneSettings {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.databasemigration.model.NeptuneSettings
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.databasemigration.model.NeptuneSettings =
      zio.aws.databasemigration.model.NeptuneSettings(
        serviceAccessRoleArn.map(value => value),
        s3BucketName,
        s3BucketFolder,
        errorRetryDuration.map(value => value),
        maxFileSize.map(value => value),
        maxRetryCount.map(value => value),
        iamAuthEnabled.map(value => value)
      )
    def serviceAccessRoleArn: Option[String]
    def s3BucketName: String
    def s3BucketFolder: String
    def errorRetryDuration: Option[IntegerOptional]
    def maxFileSize: Option[IntegerOptional]
    def maxRetryCount: Option[IntegerOptional]
    def iamAuthEnabled: Option[BooleanOptional]
    def getServiceAccessRoleArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("serviceAccessRoleArn", serviceAccessRoleArn)
    def getS3BucketName: ZIO[Any, Nothing, String] = ZIO.succeed(s3BucketName)
    def getS3BucketFolder: ZIO[Any, Nothing, String] =
      ZIO.succeed(s3BucketFolder)
    def getErrorRetryDuration: ZIO[Any, AwsError, IntegerOptional] =
      AwsError.unwrapOptionField("errorRetryDuration", errorRetryDuration)
    def getMaxFileSize: ZIO[Any, AwsError, IntegerOptional] =
      AwsError.unwrapOptionField("maxFileSize", maxFileSize)
    def getMaxRetryCount: ZIO[Any, AwsError, IntegerOptional] =
      AwsError.unwrapOptionField("maxRetryCount", maxRetryCount)
    def getIamAuthEnabled: ZIO[Any, AwsError, BooleanOptional] =
      AwsError.unwrapOptionField("iamAuthEnabled", iamAuthEnabled)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.databasemigration.model.NeptuneSettings
  ) extends zio.aws.databasemigration.model.NeptuneSettings.ReadOnly {
    override val serviceAccessRoleArn: Option[String] =
      scala.Option(impl.serviceAccessRoleArn()).map(value => value: String)
    override val s3BucketName: String = impl.s3BucketName(): String
    override val s3BucketFolder: String = impl.s3BucketFolder(): String
    override val errorRetryDuration: Option[IntegerOptional] = scala
      .Option(impl.errorRetryDuration())
      .map(value => value: IntegerOptional)
    override val maxFileSize: Option[IntegerOptional] =
      scala.Option(impl.maxFileSize()).map(value => value: IntegerOptional)
    override val maxRetryCount: Option[IntegerOptional] =
      scala.Option(impl.maxRetryCount()).map(value => value: IntegerOptional)
    override val iamAuthEnabled: Option[BooleanOptional] =
      scala.Option(impl.iamAuthEnabled()).map(value => value: BooleanOptional)
  }
  def wrap(
      impl: software.amazon.awssdk.services.databasemigration.model.NeptuneSettings
  ): zio.aws.databasemigration.model.NeptuneSettings.ReadOnly = new Wrapper(
    impl
  )
}
