package zio.aws.databasemigration.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import zio.aws.databasemigration.model.primitives.TStamp
import scala.jdk.CollectionConverters._
final case class ModifyReplicationTaskRequest(
    replicationTaskArn: String,
    replicationTaskIdentifier: Option[String] = None,
    migrationType: Option[zio.aws.databasemigration.model.MigrationTypeValue] =
      None,
    tableMappings: Option[String] = None,
    replicationTaskSettings: Option[String] = None,
    cdcStartTime: Option[TStamp] = None,
    cdcStartPosition: Option[String] = None,
    cdcStopPosition: Option[String] = None,
    taskData: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.databasemigration.model.ModifyReplicationTaskRequest = {
    import ModifyReplicationTaskRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.databasemigration.model.ModifyReplicationTaskRequest
      .builder()
      .replicationTaskArn(replicationTaskArn: java.lang.String)
      .optionallyWith(
        replicationTaskIdentifier.map(value => value: java.lang.String)
      )(_.replicationTaskIdentifier)
      .optionallyWith(migrationType.map(value => value.unwrap))(_.migrationType)
      .optionallyWith(tableMappings.map(value => value: java.lang.String))(
        _.tableMappings
      )
      .optionallyWith(
        replicationTaskSettings.map(value => value: java.lang.String)
      )(_.replicationTaskSettings)
      .optionallyWith(cdcStartTime.map(value => TStamp.unwrap(value): Instant))(
        _.cdcStartTime
      )
      .optionallyWith(cdcStartPosition.map(value => value: java.lang.String))(
        _.cdcStartPosition
      )
      .optionallyWith(cdcStopPosition.map(value => value: java.lang.String))(
        _.cdcStopPosition
      )
      .optionallyWith(taskData.map(value => value: java.lang.String))(
        _.taskData
      )
      .build()
  }
  def asReadOnly
      : zio.aws.databasemigration.model.ModifyReplicationTaskRequest.ReadOnly =
    zio.aws.databasemigration.model.ModifyReplicationTaskRequest
      .wrap(buildAwsValue())
}
object ModifyReplicationTaskRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.databasemigration.model.ModifyReplicationTaskRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.databasemigration.model.ModifyReplicationTaskRequest =
      zio.aws.databasemigration.model.ModifyReplicationTaskRequest(
        replicationTaskArn,
        replicationTaskIdentifier.map(value => value),
        migrationType.map(value => value),
        tableMappings.map(value => value),
        replicationTaskSettings.map(value => value),
        cdcStartTime.map(value => value),
        cdcStartPosition.map(value => value),
        cdcStopPosition.map(value => value),
        taskData.map(value => value)
      )
    def replicationTaskArn: String
    def replicationTaskIdentifier: Option[String]
    def migrationType
        : Option[zio.aws.databasemigration.model.MigrationTypeValue]
    def tableMappings: Option[String]
    def replicationTaskSettings: Option[String]
    def cdcStartTime: Option[TStamp]
    def cdcStartPosition: Option[String]
    def cdcStopPosition: Option[String]
    def taskData: Option[String]
    def getReplicationTaskArn: ZIO[Any, Nothing, String] =
      ZIO.succeed(replicationTaskArn)
    def getReplicationTaskIdentifier: ZIO[Any, AwsError, String] = AwsError
      .unwrapOptionField("replicationTaskIdentifier", replicationTaskIdentifier)
    def getMigrationType: ZIO[
      Any,
      AwsError,
      zio.aws.databasemigration.model.MigrationTypeValue
    ] = AwsError.unwrapOptionField("migrationType", migrationType)
    def getTableMappings: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("tableMappings", tableMappings)
    def getReplicationTaskSettings: ZIO[Any, AwsError, String] = AwsError
      .unwrapOptionField("replicationTaskSettings", replicationTaskSettings)
    def getCdcStartTime: ZIO[Any, AwsError, TStamp] =
      AwsError.unwrapOptionField("cdcStartTime", cdcStartTime)
    def getCdcStartPosition: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("cdcStartPosition", cdcStartPosition)
    def getCdcStopPosition: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("cdcStopPosition", cdcStopPosition)
    def getTaskData: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("taskData", taskData)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.databasemigration.model.ModifyReplicationTaskRequest
  ) extends zio.aws.databasemigration.model.ModifyReplicationTaskRequest.ReadOnly {
    override val replicationTaskArn: String = impl.replicationTaskArn(): String
    override val replicationTaskIdentifier: Option[String] =
      scala.Option(impl.replicationTaskIdentifier()).map(value => value: String)
    override val migrationType
        : Option[zio.aws.databasemigration.model.MigrationTypeValue] = scala
      .Option(impl.migrationType())
      .map(value =>
        zio.aws.databasemigration.model.MigrationTypeValue.wrap(value)
      )
    override val tableMappings: Option[String] =
      scala.Option(impl.tableMappings()).map(value => value: String)
    override val replicationTaskSettings: Option[String] =
      scala.Option(impl.replicationTaskSettings()).map(value => value: String)
    override val cdcStartTime: Option[TStamp] = scala
      .Option(impl.cdcStartTime())
      .map(value => zio.aws.databasemigration.model.primitives.TStamp(value))
    override val cdcStartPosition: Option[String] =
      scala.Option(impl.cdcStartPosition()).map(value => value: String)
    override val cdcStopPosition: Option[String] =
      scala.Option(impl.cdcStopPosition()).map(value => value: String)
    override val taskData: Option[String] =
      scala.Option(impl.taskData()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.databasemigration.model.ModifyReplicationTaskRequest
  ): zio.aws.databasemigration.model.ModifyReplicationTaskRequest.ReadOnly =
    new Wrapper(impl)
}
