package zio.aws.databasemigration.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class DescribeEventSubscriptionsResponse(
    marker: Option[String] = None,
    eventSubscriptionsList: Option[
      Iterable[zio.aws.databasemigration.model.EventSubscription]
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.databasemigration.model.DescribeEventSubscriptionsResponse = {
    import DescribeEventSubscriptionsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.databasemigration.model.DescribeEventSubscriptionsResponse
      .builder()
      .optionallyWith(marker.map(value => value: java.lang.String))(_.marker)
      .optionallyWith(
        eventSubscriptionsList.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.eventSubscriptionsList)
      .build()
  }
  def asReadOnly
      : zio.aws.databasemigration.model.DescribeEventSubscriptionsResponse.ReadOnly =
    zio.aws.databasemigration.model.DescribeEventSubscriptionsResponse
      .wrap(buildAwsValue())
}
object DescribeEventSubscriptionsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.databasemigration.model.DescribeEventSubscriptionsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.databasemigration.model.DescribeEventSubscriptionsResponse =
      zio.aws.databasemigration.model.DescribeEventSubscriptionsResponse(
        marker.map(value => value),
        eventSubscriptionsList.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def marker: Option[String]
    def eventSubscriptionsList: Option[
      List[zio.aws.databasemigration.model.EventSubscription.ReadOnly]
    ]
    def getMarker: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("marker", marker)
    def getEventSubscriptionsList: ZIO[Any, AwsError, List[
      zio.aws.databasemigration.model.EventSubscription.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "eventSubscriptionsList",
      eventSubscriptionsList
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.databasemigration.model.DescribeEventSubscriptionsResponse
  ) extends zio.aws.databasemigration.model.DescribeEventSubscriptionsResponse.ReadOnly {
    override val marker: Option[String] =
      scala.Option(impl.marker()).map(value => value: String)
    override val eventSubscriptionsList: Option[
      List[zio.aws.databasemigration.model.EventSubscription.ReadOnly]
    ] = scala
      .Option(impl.eventSubscriptionsList())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.databasemigration.model.EventSubscription.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.databasemigration.model.DescribeEventSubscriptionsResponse
  ): zio.aws.databasemigration.model.DescribeEventSubscriptionsResponse.ReadOnly =
    new Wrapper(impl)
}
