package zio.aws.databasemigration.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class DescribeSchemasResponse(
    marker: Option[String] = None,
    schemas: Option[Iterable[String]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.databasemigration.model.DescribeSchemasResponse = {
    import DescribeSchemasResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.databasemigration.model.DescribeSchemasResponse
      .builder()
      .optionallyWith(marker.map(value => value: java.lang.String))(_.marker)
      .optionallyWith(
        schemas.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.schemas)
      .build()
  }
  def asReadOnly
      : zio.aws.databasemigration.model.DescribeSchemasResponse.ReadOnly =
    zio.aws.databasemigration.model.DescribeSchemasResponse
      .wrap(buildAwsValue())
}
object DescribeSchemasResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.databasemigration.model.DescribeSchemasResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.databasemigration.model.DescribeSchemasResponse =
      zio.aws.databasemigration.model.DescribeSchemasResponse(
        marker.map(value => value),
        schemas.map(value => value)
      )
    def marker: Option[String]
    def schemas: Option[List[String]]
    def getMarker: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("marker", marker)
    def getSchemas: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("schemas", schemas)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.databasemigration.model.DescribeSchemasResponse
  ) extends zio.aws.databasemigration.model.DescribeSchemasResponse.ReadOnly {
    override val marker: Option[String] =
      scala.Option(impl.marker()).map(value => value: String)
    override val schemas: Option[List[String]] = scala
      .Option(impl.schemas())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.databasemigration.model.DescribeSchemasResponse
  ): zio.aws.databasemigration.model.DescribeSchemasResponse.ReadOnly =
    new Wrapper(impl)
}
