package zio.aws.databasemigration.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.databasemigration.model.primitives.IntegerOptional
import scala.jdk.CollectionConverters._
final case class DescribeTableStatisticsRequest(
    replicationTaskArn: String,
    maxRecords: Option[IntegerOptional] = None,
    marker: Option[String] = None,
    filters: Option[Iterable[zio.aws.databasemigration.model.Filter]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.databasemigration.model.DescribeTableStatisticsRequest = {
    import DescribeTableStatisticsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.databasemigration.model.DescribeTableStatisticsRequest
      .builder()
      .replicationTaskArn(replicationTaskArn: java.lang.String)
      .optionallyWith(
        maxRecords.map(value => IntegerOptional.unwrap(value): Integer)
      )(_.maxRecords)
      .optionallyWith(marker.map(value => value: java.lang.String))(_.marker)
      .optionallyWith(
        filters.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.filters)
      .build()
  }
  def asReadOnly
      : zio.aws.databasemigration.model.DescribeTableStatisticsRequest.ReadOnly =
    zio.aws.databasemigration.model.DescribeTableStatisticsRequest
      .wrap(buildAwsValue())
}
object DescribeTableStatisticsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.databasemigration.model.DescribeTableStatisticsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.databasemigration.model.DescribeTableStatisticsRequest =
      zio.aws.databasemigration.model.DescribeTableStatisticsRequest(
        replicationTaskArn,
        maxRecords.map(value => value),
        marker.map(value => value),
        filters.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def replicationTaskArn: String
    def maxRecords: Option[IntegerOptional]
    def marker: Option[String]
    def filters: Option[List[zio.aws.databasemigration.model.Filter.ReadOnly]]
    def getReplicationTaskArn: ZIO[Any, Nothing, String] =
      ZIO.succeed(replicationTaskArn)
    def getMaxRecords: ZIO[Any, AwsError, IntegerOptional] =
      AwsError.unwrapOptionField("maxRecords", maxRecords)
    def getMarker: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("marker", marker)
    def getFilters: ZIO[Any, AwsError, List[
      zio.aws.databasemigration.model.Filter.ReadOnly
    ]] = AwsError.unwrapOptionField("filters", filters)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.databasemigration.model.DescribeTableStatisticsRequest
  ) extends zio.aws.databasemigration.model.DescribeTableStatisticsRequest.ReadOnly {
    override val replicationTaskArn: String = impl.replicationTaskArn(): String
    override val maxRecords: Option[IntegerOptional] = scala
      .Option(impl.maxRecords())
      .map(value =>
        zio.aws.databasemigration.model.primitives.IntegerOptional(value)
      )
    override val marker: Option[String] =
      scala.Option(impl.marker()).map(value => value: String)
    override val filters
        : Option[List[zio.aws.databasemigration.model.Filter.ReadOnly]] = scala
      .Option(impl.filters())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.databasemigration.model.Filter.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.databasemigration.model.DescribeTableStatisticsRequest
  ): zio.aws.databasemigration.model.DescribeTableStatisticsRequest.ReadOnly =
    new Wrapper(impl)
}
