package zio.aws.databasemigration.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class RebootReplicationInstanceResponse(
    replicationInstance: Option[
      zio.aws.databasemigration.model.ReplicationInstance
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.databasemigration.model.RebootReplicationInstanceResponse = {
    import RebootReplicationInstanceResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.databasemigration.model.RebootReplicationInstanceResponse
      .builder()
      .optionallyWith(replicationInstance.map(value => value.buildAwsValue()))(
        _.replicationInstance
      )
      .build()
  }
  def asReadOnly
      : zio.aws.databasemigration.model.RebootReplicationInstanceResponse.ReadOnly =
    zio.aws.databasemigration.model.RebootReplicationInstanceResponse
      .wrap(buildAwsValue())
}
object RebootReplicationInstanceResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.databasemigration.model.RebootReplicationInstanceResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.databasemigration.model.RebootReplicationInstanceResponse =
      zio.aws.databasemigration.model.RebootReplicationInstanceResponse(
        replicationInstance.map(value => value.asEditable)
      )
    def replicationInstance
        : Option[zio.aws.databasemigration.model.ReplicationInstance.ReadOnly]
    def getReplicationInstance: ZIO[
      Any,
      AwsError,
      zio.aws.databasemigration.model.ReplicationInstance.ReadOnly
    ] = AwsError.unwrapOptionField("replicationInstance", replicationInstance)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.databasemigration.model.RebootReplicationInstanceResponse
  ) extends zio.aws.databasemigration.model.RebootReplicationInstanceResponse.ReadOnly {
    override val replicationInstance
        : Option[zio.aws.databasemigration.model.ReplicationInstance.ReadOnly] =
      scala
        .Option(impl.replicationInstance())
        .map(value =>
          zio.aws.databasemigration.model.ReplicationInstance.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.databasemigration.model.RebootReplicationInstanceResponse
  ): zio.aws.databasemigration.model.RebootReplicationInstanceResponse.ReadOnly =
    new Wrapper(impl)
}
