package zio.aws.databasemigration.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class DescribeEventCategoriesResponse(
    eventCategoryGroupList: Option[
      Iterable[zio.aws.databasemigration.model.EventCategoryGroup]
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.databasemigration.model.DescribeEventCategoriesResponse = {
    import DescribeEventCategoriesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.databasemigration.model.DescribeEventCategoriesResponse
      .builder()
      .optionallyWith(
        eventCategoryGroupList.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.eventCategoryGroupList)
      .build()
  }
  def asReadOnly
      : zio.aws.databasemigration.model.DescribeEventCategoriesResponse.ReadOnly =
    zio.aws.databasemigration.model.DescribeEventCategoriesResponse
      .wrap(buildAwsValue())
}
object DescribeEventCategoriesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.databasemigration.model.DescribeEventCategoriesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.databasemigration.model.DescribeEventCategoriesResponse =
      zio.aws.databasemigration.model.DescribeEventCategoriesResponse(
        eventCategoryGroupList.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def eventCategoryGroupList: Option[
      List[zio.aws.databasemigration.model.EventCategoryGroup.ReadOnly]
    ]
    def getEventCategoryGroupList: ZIO[Any, AwsError, List[
      zio.aws.databasemigration.model.EventCategoryGroup.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "eventCategoryGroupList",
      eventCategoryGroupList
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.databasemigration.model.DescribeEventCategoriesResponse
  ) extends zio.aws.databasemigration.model.DescribeEventCategoriesResponse.ReadOnly {
    override val eventCategoryGroupList: Option[
      List[zio.aws.databasemigration.model.EventCategoryGroup.ReadOnly]
    ] = scala
      .Option(impl.eventCategoryGroupList())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.databasemigration.model.EventCategoryGroup.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.databasemigration.model.DescribeEventCategoriesResponse
  ): zio.aws.databasemigration.model.DescribeEventCategoriesResponse.ReadOnly =
    new Wrapper(impl)
}
