package zio.aws.databasemigration.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.databasemigration.model.primitives.{
  BooleanOptional,
  SecretString,
  IntegerOptional
}
import scala.jdk.CollectionConverters._
final case class MicrosoftSQLServerSettings(
    port: Option[IntegerOptional] = None,
    bcpPacketSize: Option[IntegerOptional] = None,
    databaseName: Option[String] = None,
    controlTablesFileGroup: Option[String] = None,
    password: Option[SecretString] = None,
    querySingleAlwaysOnNode: Option[BooleanOptional] = None,
    readBackupOnly: Option[BooleanOptional] = None,
    safeguardPolicy: Option[zio.aws.databasemigration.model.SafeguardPolicy] =
      None,
    serverName: Option[String] = None,
    username: Option[String] = None,
    useBcpFullLoad: Option[BooleanOptional] = None,
    useThirdPartyBackupDevice: Option[BooleanOptional] = None,
    secretsManagerAccessRoleArn: Option[String] = None,
    secretsManagerSecretId: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.databasemigration.model.MicrosoftSQLServerSettings = {
    import MicrosoftSQLServerSettings.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.databasemigration.model.MicrosoftSQLServerSettings
      .builder()
      .optionallyWith(
        port.map(value => IntegerOptional.unwrap(value): Integer)
      )(_.port)
      .optionallyWith(
        bcpPacketSize.map(value => IntegerOptional.unwrap(value): Integer)
      )(_.bcpPacketSize)
      .optionallyWith(databaseName.map(value => value: java.lang.String))(
        _.databaseName
      )
      .optionallyWith(
        controlTablesFileGroup.map(value => value: java.lang.String)
      )(_.controlTablesFileGroup)
      .optionallyWith(
        password.map(value => SecretString.unwrap(value): java.lang.String)
      )(_.password)
      .optionallyWith(
        querySingleAlwaysOnNode.map(value =>
          BooleanOptional.unwrap(value): java.lang.Boolean
        )
      )(_.querySingleAlwaysOnNode)
      .optionallyWith(
        readBackupOnly.map(value =>
          BooleanOptional.unwrap(value): java.lang.Boolean
        )
      )(_.readBackupOnly)
      .optionallyWith(safeguardPolicy.map(value => value.unwrap))(
        _.safeguardPolicy
      )
      .optionallyWith(serverName.map(value => value: java.lang.String))(
        _.serverName
      )
      .optionallyWith(username.map(value => value: java.lang.String))(
        _.username
      )
      .optionallyWith(
        useBcpFullLoad.map(value =>
          BooleanOptional.unwrap(value): java.lang.Boolean
        )
      )(_.useBcpFullLoad)
      .optionallyWith(
        useThirdPartyBackupDevice.map(value =>
          BooleanOptional.unwrap(value): java.lang.Boolean
        )
      )(_.useThirdPartyBackupDevice)
      .optionallyWith(
        secretsManagerAccessRoleArn.map(value => value: java.lang.String)
      )(_.secretsManagerAccessRoleArn)
      .optionallyWith(
        secretsManagerSecretId.map(value => value: java.lang.String)
      )(_.secretsManagerSecretId)
      .build()
  }
  def asReadOnly
      : zio.aws.databasemigration.model.MicrosoftSQLServerSettings.ReadOnly =
    zio.aws.databasemigration.model.MicrosoftSQLServerSettings
      .wrap(buildAwsValue())
}
object MicrosoftSQLServerSettings {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.databasemigration.model.MicrosoftSQLServerSettings
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.databasemigration.model.MicrosoftSQLServerSettings =
      zio.aws.databasemigration.model.MicrosoftSQLServerSettings(
        port.map(value => value),
        bcpPacketSize.map(value => value),
        databaseName.map(value => value),
        controlTablesFileGroup.map(value => value),
        password.map(value => value),
        querySingleAlwaysOnNode.map(value => value),
        readBackupOnly.map(value => value),
        safeguardPolicy.map(value => value),
        serverName.map(value => value),
        username.map(value => value),
        useBcpFullLoad.map(value => value),
        useThirdPartyBackupDevice.map(value => value),
        secretsManagerAccessRoleArn.map(value => value),
        secretsManagerSecretId.map(value => value)
      )
    def port: Option[IntegerOptional]
    def bcpPacketSize: Option[IntegerOptional]
    def databaseName: Option[String]
    def controlTablesFileGroup: Option[String]
    def password: Option[SecretString]
    def querySingleAlwaysOnNode: Option[BooleanOptional]
    def readBackupOnly: Option[BooleanOptional]
    def safeguardPolicy: Option[zio.aws.databasemigration.model.SafeguardPolicy]
    def serverName: Option[String]
    def username: Option[String]
    def useBcpFullLoad: Option[BooleanOptional]
    def useThirdPartyBackupDevice: Option[BooleanOptional]
    def secretsManagerAccessRoleArn: Option[String]
    def secretsManagerSecretId: Option[String]
    def getPort: ZIO[Any, AwsError, IntegerOptional] =
      AwsError.unwrapOptionField("port", port)
    def getBcpPacketSize: ZIO[Any, AwsError, IntegerOptional] =
      AwsError.unwrapOptionField("bcpPacketSize", bcpPacketSize)
    def getDatabaseName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("databaseName", databaseName)
    def getControlTablesFileGroup: ZIO[Any, AwsError, String] = AwsError
      .unwrapOptionField("controlTablesFileGroup", controlTablesFileGroup)
    def getPassword: ZIO[Any, AwsError, SecretString] =
      AwsError.unwrapOptionField("password", password)
    def getQuerySingleAlwaysOnNode: ZIO[Any, AwsError, BooleanOptional] =
      AwsError.unwrapOptionField(
        "querySingleAlwaysOnNode",
        querySingleAlwaysOnNode
      )
    def getReadBackupOnly: ZIO[Any, AwsError, BooleanOptional] =
      AwsError.unwrapOptionField("readBackupOnly", readBackupOnly)
    def getSafeguardPolicy
        : ZIO[Any, AwsError, zio.aws.databasemigration.model.SafeguardPolicy] =
      AwsError.unwrapOptionField("safeguardPolicy", safeguardPolicy)
    def getServerName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("serverName", serverName)
    def getUsername: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("username", username)
    def getUseBcpFullLoad: ZIO[Any, AwsError, BooleanOptional] =
      AwsError.unwrapOptionField("useBcpFullLoad", useBcpFullLoad)
    def getUseThirdPartyBackupDevice: ZIO[Any, AwsError, BooleanOptional] =
      AwsError.unwrapOptionField(
        "useThirdPartyBackupDevice",
        useThirdPartyBackupDevice
      )
    def getSecretsManagerAccessRoleArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField(
        "secretsManagerAccessRoleArn",
        secretsManagerAccessRoleArn
      )
    def getSecretsManagerSecretId: ZIO[Any, AwsError, String] = AwsError
      .unwrapOptionField("secretsManagerSecretId", secretsManagerSecretId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.databasemigration.model.MicrosoftSQLServerSettings
  ) extends zio.aws.databasemigration.model.MicrosoftSQLServerSettings.ReadOnly {
    override val port: Option[IntegerOptional] = scala
      .Option(impl.port())
      .map(value =>
        zio.aws.databasemigration.model.primitives.IntegerOptional(value)
      )
    override val bcpPacketSize: Option[IntegerOptional] = scala
      .Option(impl.bcpPacketSize())
      .map(value =>
        zio.aws.databasemigration.model.primitives.IntegerOptional(value)
      )
    override val databaseName: Option[String] =
      scala.Option(impl.databaseName()).map(value => value: String)
    override val controlTablesFileGroup: Option[String] =
      scala.Option(impl.controlTablesFileGroup()).map(value => value: String)
    override val password: Option[SecretString] = scala
      .Option(impl.password())
      .map(value =>
        zio.aws.databasemigration.model.primitives.SecretString(value)
      )
    override val querySingleAlwaysOnNode: Option[BooleanOptional] = scala
      .Option(impl.querySingleAlwaysOnNode())
      .map(value =>
        zio.aws.databasemigration.model.primitives.BooleanOptional(value)
      )
    override val readBackupOnly: Option[BooleanOptional] = scala
      .Option(impl.readBackupOnly())
      .map(value =>
        zio.aws.databasemigration.model.primitives.BooleanOptional(value)
      )
    override val safeguardPolicy
        : Option[zio.aws.databasemigration.model.SafeguardPolicy] = scala
      .Option(impl.safeguardPolicy())
      .map(value => zio.aws.databasemigration.model.SafeguardPolicy.wrap(value))
    override val serverName: Option[String] =
      scala.Option(impl.serverName()).map(value => value: String)
    override val username: Option[String] =
      scala.Option(impl.username()).map(value => value: String)
    override val useBcpFullLoad: Option[BooleanOptional] = scala
      .Option(impl.useBcpFullLoad())
      .map(value =>
        zio.aws.databasemigration.model.primitives.BooleanOptional(value)
      )
    override val useThirdPartyBackupDevice: Option[BooleanOptional] = scala
      .Option(impl.useThirdPartyBackupDevice())
      .map(value =>
        zio.aws.databasemigration.model.primitives.BooleanOptional(value)
      )
    override val secretsManagerAccessRoleArn: Option[String] = scala
      .Option(impl.secretsManagerAccessRoleArn())
      .map(value => value: String)
    override val secretsManagerSecretId: Option[String] =
      scala.Option(impl.secretsManagerSecretId()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.databasemigration.model.MicrosoftSQLServerSettings
  ): zio.aws.databasemigration.model.MicrosoftSQLServerSettings.ReadOnly =
    new Wrapper(impl)
}
