package zio.aws.databasemigration.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.databasemigration.model.primitives.{
  SecretString,
  IntegerOptional,
  BooleanOptional
}
import scala.jdk.CollectionConverters._
final case class KafkaSettings(
    broker: Option[String] = None,
    topic: Option[String] = None,
    messageFormat: Option[zio.aws.databasemigration.model.MessageFormatValue] =
      None,
    includeTransactionDetails: Option[BooleanOptional] = None,
    includePartitionValue: Option[BooleanOptional] = None,
    partitionIncludeSchemaTable: Option[BooleanOptional] = None,
    includeTableAlterOperations: Option[BooleanOptional] = None,
    includeControlDetails: Option[BooleanOptional] = None,
    messageMaxBytes: Option[IntegerOptional] = None,
    includeNullAndEmpty: Option[BooleanOptional] = None,
    securityProtocol: Option[
      zio.aws.databasemigration.model.KafkaSecurityProtocol
    ] = None,
    sslClientCertificateArn: Option[String] = None,
    sslClientKeyArn: Option[String] = None,
    sslClientKeyPassword: Option[SecretString] = None,
    sslCaCertificateArn: Option[String] = None,
    saslUsername: Option[String] = None,
    saslPassword: Option[SecretString] = None,
    noHexPrefix: Option[BooleanOptional] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.databasemigration.model.KafkaSettings = {
    import KafkaSettings.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.databasemigration.model.KafkaSettings
      .builder()
      .optionallyWith(broker.map(value => value: java.lang.String))(_.broker)
      .optionallyWith(topic.map(value => value: java.lang.String))(_.topic)
      .optionallyWith(messageFormat.map(value => value.unwrap))(_.messageFormat)
      .optionallyWith(
        includeTransactionDetails.map(value =>
          BooleanOptional.unwrap(value): java.lang.Boolean
        )
      )(_.includeTransactionDetails)
      .optionallyWith(
        includePartitionValue.map(value =>
          BooleanOptional.unwrap(value): java.lang.Boolean
        )
      )(_.includePartitionValue)
      .optionallyWith(
        partitionIncludeSchemaTable.map(value =>
          BooleanOptional.unwrap(value): java.lang.Boolean
        )
      )(_.partitionIncludeSchemaTable)
      .optionallyWith(
        includeTableAlterOperations.map(value =>
          BooleanOptional.unwrap(value): java.lang.Boolean
        )
      )(_.includeTableAlterOperations)
      .optionallyWith(
        includeControlDetails.map(value =>
          BooleanOptional.unwrap(value): java.lang.Boolean
        )
      )(_.includeControlDetails)
      .optionallyWith(
        messageMaxBytes.map(value => IntegerOptional.unwrap(value): Integer)
      )(_.messageMaxBytes)
      .optionallyWith(
        includeNullAndEmpty.map(value =>
          BooleanOptional.unwrap(value): java.lang.Boolean
        )
      )(_.includeNullAndEmpty)
      .optionallyWith(securityProtocol.map(value => value.unwrap))(
        _.securityProtocol
      )
      .optionallyWith(
        sslClientCertificateArn.map(value => value: java.lang.String)
      )(_.sslClientCertificateArn)
      .optionallyWith(sslClientKeyArn.map(value => value: java.lang.String))(
        _.sslClientKeyArn
      )
      .optionallyWith(
        sslClientKeyPassword.map(value =>
          SecretString.unwrap(value): java.lang.String
        )
      )(_.sslClientKeyPassword)
      .optionallyWith(
        sslCaCertificateArn.map(value => value: java.lang.String)
      )(_.sslCaCertificateArn)
      .optionallyWith(saslUsername.map(value => value: java.lang.String))(
        _.saslUsername
      )
      .optionallyWith(
        saslPassword.map(value => SecretString.unwrap(value): java.lang.String)
      )(_.saslPassword)
      .optionallyWith(
        noHexPrefix.map(value =>
          BooleanOptional.unwrap(value): java.lang.Boolean
        )
      )(_.noHexPrefix)
      .build()
  }
  def asReadOnly: zio.aws.databasemigration.model.KafkaSettings.ReadOnly =
    zio.aws.databasemigration.model.KafkaSettings.wrap(buildAwsValue())
}
object KafkaSettings {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.databasemigration.model.KafkaSettings
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.databasemigration.model.KafkaSettings =
      zio.aws.databasemigration.model.KafkaSettings(
        broker.map(value => value),
        topic.map(value => value),
        messageFormat.map(value => value),
        includeTransactionDetails.map(value => value),
        includePartitionValue.map(value => value),
        partitionIncludeSchemaTable.map(value => value),
        includeTableAlterOperations.map(value => value),
        includeControlDetails.map(value => value),
        messageMaxBytes.map(value => value),
        includeNullAndEmpty.map(value => value),
        securityProtocol.map(value => value),
        sslClientCertificateArn.map(value => value),
        sslClientKeyArn.map(value => value),
        sslClientKeyPassword.map(value => value),
        sslCaCertificateArn.map(value => value),
        saslUsername.map(value => value),
        saslPassword.map(value => value),
        noHexPrefix.map(value => value)
      )
    def broker: Option[String]
    def topic: Option[String]
    def messageFormat
        : Option[zio.aws.databasemigration.model.MessageFormatValue]
    def includeTransactionDetails: Option[BooleanOptional]
    def includePartitionValue: Option[BooleanOptional]
    def partitionIncludeSchemaTable: Option[BooleanOptional]
    def includeTableAlterOperations: Option[BooleanOptional]
    def includeControlDetails: Option[BooleanOptional]
    def messageMaxBytes: Option[IntegerOptional]
    def includeNullAndEmpty: Option[BooleanOptional]
    def securityProtocol
        : Option[zio.aws.databasemigration.model.KafkaSecurityProtocol]
    def sslClientCertificateArn: Option[String]
    def sslClientKeyArn: Option[String]
    def sslClientKeyPassword: Option[SecretString]
    def sslCaCertificateArn: Option[String]
    def saslUsername: Option[String]
    def saslPassword: Option[SecretString]
    def noHexPrefix: Option[BooleanOptional]
    def getBroker: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("broker", broker)
    def getTopic: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("topic", topic)
    def getMessageFormat: ZIO[
      Any,
      AwsError,
      zio.aws.databasemigration.model.MessageFormatValue
    ] = AwsError.unwrapOptionField("messageFormat", messageFormat)
    def getIncludeTransactionDetails: ZIO[Any, AwsError, BooleanOptional] =
      AwsError.unwrapOptionField(
        "includeTransactionDetails",
        includeTransactionDetails
      )
    def getIncludePartitionValue: ZIO[Any, AwsError, BooleanOptional] =
      AwsError.unwrapOptionField("includePartitionValue", includePartitionValue)
    def getPartitionIncludeSchemaTable: ZIO[Any, AwsError, BooleanOptional] =
      AwsError.unwrapOptionField(
        "partitionIncludeSchemaTable",
        partitionIncludeSchemaTable
      )
    def getIncludeTableAlterOperations: ZIO[Any, AwsError, BooleanOptional] =
      AwsError.unwrapOptionField(
        "includeTableAlterOperations",
        includeTableAlterOperations
      )
    def getIncludeControlDetails: ZIO[Any, AwsError, BooleanOptional] =
      AwsError.unwrapOptionField("includeControlDetails", includeControlDetails)
    def getMessageMaxBytes: ZIO[Any, AwsError, IntegerOptional] =
      AwsError.unwrapOptionField("messageMaxBytes", messageMaxBytes)
    def getIncludeNullAndEmpty: ZIO[Any, AwsError, BooleanOptional] =
      AwsError.unwrapOptionField("includeNullAndEmpty", includeNullAndEmpty)
    def getSecurityProtocol: ZIO[
      Any,
      AwsError,
      zio.aws.databasemigration.model.KafkaSecurityProtocol
    ] = AwsError.unwrapOptionField("securityProtocol", securityProtocol)
    def getSslClientCertificateArn: ZIO[Any, AwsError, String] = AwsError
      .unwrapOptionField("sslClientCertificateArn", sslClientCertificateArn)
    def getSslClientKeyArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("sslClientKeyArn", sslClientKeyArn)
    def getSslClientKeyPassword: ZIO[Any, AwsError, SecretString] =
      AwsError.unwrapOptionField("sslClientKeyPassword", sslClientKeyPassword)
    def getSslCaCertificateArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("sslCaCertificateArn", sslCaCertificateArn)
    def getSaslUsername: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("saslUsername", saslUsername)
    def getSaslPassword: ZIO[Any, AwsError, SecretString] =
      AwsError.unwrapOptionField("saslPassword", saslPassword)
    def getNoHexPrefix: ZIO[Any, AwsError, BooleanOptional] =
      AwsError.unwrapOptionField("noHexPrefix", noHexPrefix)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.databasemigration.model.KafkaSettings
  ) extends zio.aws.databasemigration.model.KafkaSettings.ReadOnly {
    override val broker: Option[String] =
      scala.Option(impl.broker()).map(value => value: String)
    override val topic: Option[String] =
      scala.Option(impl.topic()).map(value => value: String)
    override val messageFormat
        : Option[zio.aws.databasemigration.model.MessageFormatValue] = scala
      .Option(impl.messageFormat())
      .map(value =>
        zio.aws.databasemigration.model.MessageFormatValue.wrap(value)
      )
    override val includeTransactionDetails: Option[BooleanOptional] = scala
      .Option(impl.includeTransactionDetails())
      .map(value =>
        zio.aws.databasemigration.model.primitives.BooleanOptional(value)
      )
    override val includePartitionValue: Option[BooleanOptional] = scala
      .Option(impl.includePartitionValue())
      .map(value =>
        zio.aws.databasemigration.model.primitives.BooleanOptional(value)
      )
    override val partitionIncludeSchemaTable: Option[BooleanOptional] = scala
      .Option(impl.partitionIncludeSchemaTable())
      .map(value =>
        zio.aws.databasemigration.model.primitives.BooleanOptional(value)
      )
    override val includeTableAlterOperations: Option[BooleanOptional] = scala
      .Option(impl.includeTableAlterOperations())
      .map(value =>
        zio.aws.databasemigration.model.primitives.BooleanOptional(value)
      )
    override val includeControlDetails: Option[BooleanOptional] = scala
      .Option(impl.includeControlDetails())
      .map(value =>
        zio.aws.databasemigration.model.primitives.BooleanOptional(value)
      )
    override val messageMaxBytes: Option[IntegerOptional] = scala
      .Option(impl.messageMaxBytes())
      .map(value =>
        zio.aws.databasemigration.model.primitives.IntegerOptional(value)
      )
    override val includeNullAndEmpty: Option[BooleanOptional] = scala
      .Option(impl.includeNullAndEmpty())
      .map(value =>
        zio.aws.databasemigration.model.primitives.BooleanOptional(value)
      )
    override val securityProtocol
        : Option[zio.aws.databasemigration.model.KafkaSecurityProtocol] = scala
      .Option(impl.securityProtocol())
      .map(value =>
        zio.aws.databasemigration.model.KafkaSecurityProtocol.wrap(value)
      )
    override val sslClientCertificateArn: Option[String] =
      scala.Option(impl.sslClientCertificateArn()).map(value => value: String)
    override val sslClientKeyArn: Option[String] =
      scala.Option(impl.sslClientKeyArn()).map(value => value: String)
    override val sslClientKeyPassword: Option[SecretString] = scala
      .Option(impl.sslClientKeyPassword())
      .map(value =>
        zio.aws.databasemigration.model.primitives.SecretString(value)
      )
    override val sslCaCertificateArn: Option[String] =
      scala.Option(impl.sslCaCertificateArn()).map(value => value: String)
    override val saslUsername: Option[String] =
      scala.Option(impl.saslUsername()).map(value => value: String)
    override val saslPassword: Option[SecretString] = scala
      .Option(impl.saslPassword())
      .map(value =>
        zio.aws.databasemigration.model.primitives.SecretString(value)
      )
    override val noHexPrefix: Option[BooleanOptional] = scala
      .Option(impl.noHexPrefix())
      .map(value =>
        zio.aws.databasemigration.model.primitives.BooleanOptional(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.databasemigration.model.KafkaSettings
  ): zio.aws.databasemigration.model.KafkaSettings.ReadOnly = new Wrapper(impl)
}
