package zio.aws.databasemigration.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ReloadTablesRequest(
    replicationTaskArn: String,
    tablesToReload: Iterable[zio.aws.databasemigration.model.TableToReload],
    reloadOption: Option[zio.aws.databasemigration.model.ReloadOptionValue] =
      None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.databasemigration.model.ReloadTablesRequest = {
    import ReloadTablesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.databasemigration.model.ReloadTablesRequest
      .builder()
      .replicationTaskArn(replicationTaskArn: java.lang.String)
      .tablesToReload(tablesToReload.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .optionallyWith(reloadOption.map(value => value.unwrap))(_.reloadOption)
      .build()
  }
  def asReadOnly: zio.aws.databasemigration.model.ReloadTablesRequest.ReadOnly =
    zio.aws.databasemigration.model.ReloadTablesRequest.wrap(buildAwsValue())
}
object ReloadTablesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.databasemigration.model.ReloadTablesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.databasemigration.model.ReloadTablesRequest =
      zio.aws.databasemigration.model.ReloadTablesRequest(
        replicationTaskArn,
        tablesToReload.map { item =>
          item.asEditable
        },
        reloadOption.map(value => value)
      )
    def replicationTaskArn: String
    def tablesToReload
        : List[zio.aws.databasemigration.model.TableToReload.ReadOnly]
    def reloadOption: Option[zio.aws.databasemigration.model.ReloadOptionValue]
    def getReplicationTaskArn: ZIO[Any, Nothing, String] =
      ZIO.succeed(replicationTaskArn)
    def getTablesToReload: ZIO[Any, Nothing, List[
      zio.aws.databasemigration.model.TableToReload.ReadOnly
    ]] = ZIO.succeed(tablesToReload)
    def getReloadOption: ZIO[
      Any,
      AwsError,
      zio.aws.databasemigration.model.ReloadOptionValue
    ] = AwsError.unwrapOptionField("reloadOption", reloadOption)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.databasemigration.model.ReloadTablesRequest
  ) extends zio.aws.databasemigration.model.ReloadTablesRequest.ReadOnly {
    override val replicationTaskArn: String = impl.replicationTaskArn(): String
    override val tablesToReload
        : List[zio.aws.databasemigration.model.TableToReload.ReadOnly] = impl
      .tablesToReload()
      .asScala
      .map { item =>
        zio.aws.databasemigration.model.TableToReload.wrap(item)
      }
      .toList
    override val reloadOption
        : Option[zio.aws.databasemigration.model.ReloadOptionValue] = scala
      .Option(impl.reloadOption())
      .map(value =>
        zio.aws.databasemigration.model.ReloadOptionValue.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.databasemigration.model.ReloadTablesRequest
  ): zio.aws.databasemigration.model.ReloadTablesRequest.ReadOnly = new Wrapper(
    impl
  )
}
