package zio.aws.databasemigration.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.databasemigration.model.primitives.Integer
import scala.jdk.CollectionConverters._
final case class OrderableReplicationInstance(
    engineVersion: Option[String] = None,
    replicationInstanceClass: Option[String] = None,
    storageType: Option[String] = None,
    minAllocatedStorage: Option[Integer] = None,
    maxAllocatedStorage: Option[Integer] = None,
    defaultAllocatedStorage: Option[Integer] = None,
    includedAllocatedStorage: Option[Integer] = None,
    availabilityZones: Option[Iterable[String]] = None,
    releaseStatus: Option[zio.aws.databasemigration.model.ReleaseStatusValues] =
      None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.databasemigration.model.OrderableReplicationInstance = {
    import OrderableReplicationInstance.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.databasemigration.model.OrderableReplicationInstance
      .builder()
      .optionallyWith(engineVersion.map(value => value: java.lang.String))(
        _.engineVersion
      )
      .optionallyWith(
        replicationInstanceClass.map(value => value: java.lang.String)
      )(_.replicationInstanceClass)
      .optionallyWith(storageType.map(value => value: java.lang.String))(
        _.storageType
      )
      .optionallyWith(
        minAllocatedStorage.map(value =>
          Integer.unwrap(value): java.lang.Integer
        )
      )(_.minAllocatedStorage)
      .optionallyWith(
        maxAllocatedStorage.map(value =>
          Integer.unwrap(value): java.lang.Integer
        )
      )(_.maxAllocatedStorage)
      .optionallyWith(
        defaultAllocatedStorage.map(value =>
          Integer.unwrap(value): java.lang.Integer
        )
      )(_.defaultAllocatedStorage)
      .optionallyWith(
        includedAllocatedStorage.map(value =>
          Integer.unwrap(value): java.lang.Integer
        )
      )(_.includedAllocatedStorage)
      .optionallyWith(
        availabilityZones.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.availabilityZones)
      .optionallyWith(releaseStatus.map(value => value.unwrap))(_.releaseStatus)
      .build()
  }
  def asReadOnly
      : zio.aws.databasemigration.model.OrderableReplicationInstance.ReadOnly =
    zio.aws.databasemigration.model.OrderableReplicationInstance
      .wrap(buildAwsValue())
}
object OrderableReplicationInstance {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.databasemigration.model.OrderableReplicationInstance
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.databasemigration.model.OrderableReplicationInstance =
      zio.aws.databasemigration.model.OrderableReplicationInstance(
        engineVersion.map(value => value),
        replicationInstanceClass.map(value => value),
        storageType.map(value => value),
        minAllocatedStorage.map(value => value),
        maxAllocatedStorage.map(value => value),
        defaultAllocatedStorage.map(value => value),
        includedAllocatedStorage.map(value => value),
        availabilityZones.map(value => value),
        releaseStatus.map(value => value)
      )
    def engineVersion: Option[String]
    def replicationInstanceClass: Option[String]
    def storageType: Option[String]
    def minAllocatedStorage: Option[Integer]
    def maxAllocatedStorage: Option[Integer]
    def defaultAllocatedStorage: Option[Integer]
    def includedAllocatedStorage: Option[Integer]
    def availabilityZones: Option[List[String]]
    def releaseStatus
        : Option[zio.aws.databasemigration.model.ReleaseStatusValues]
    def getEngineVersion: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("engineVersion", engineVersion)
    def getReplicationInstanceClass: ZIO[Any, AwsError, String] = AwsError
      .unwrapOptionField("replicationInstanceClass", replicationInstanceClass)
    def getStorageType: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("storageType", storageType)
    def getMinAllocatedStorage: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("minAllocatedStorage", minAllocatedStorage)
    def getMaxAllocatedStorage: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("maxAllocatedStorage", maxAllocatedStorage)
    def getDefaultAllocatedStorage: ZIO[Any, AwsError, Integer] = AwsError
      .unwrapOptionField("defaultAllocatedStorage", defaultAllocatedStorage)
    def getIncludedAllocatedStorage: ZIO[Any, AwsError, Integer] = AwsError
      .unwrapOptionField("includedAllocatedStorage", includedAllocatedStorage)
    def getAvailabilityZones: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("availabilityZones", availabilityZones)
    def getReleaseStatus: ZIO[
      Any,
      AwsError,
      zio.aws.databasemigration.model.ReleaseStatusValues
    ] = AwsError.unwrapOptionField("releaseStatus", releaseStatus)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.databasemigration.model.OrderableReplicationInstance
  ) extends zio.aws.databasemigration.model.OrderableReplicationInstance.ReadOnly {
    override val engineVersion: Option[String] =
      scala.Option(impl.engineVersion()).map(value => value: String)
    override val replicationInstanceClass: Option[String] =
      scala.Option(impl.replicationInstanceClass()).map(value => value: String)
    override val storageType: Option[String] =
      scala.Option(impl.storageType()).map(value => value: String)
    override val minAllocatedStorage: Option[Integer] = scala
      .Option(impl.minAllocatedStorage())
      .map(value => zio.aws.databasemigration.model.primitives.Integer(value))
    override val maxAllocatedStorage: Option[Integer] = scala
      .Option(impl.maxAllocatedStorage())
      .map(value => zio.aws.databasemigration.model.primitives.Integer(value))
    override val defaultAllocatedStorage: Option[Integer] = scala
      .Option(impl.defaultAllocatedStorage())
      .map(value => zio.aws.databasemigration.model.primitives.Integer(value))
    override val includedAllocatedStorage: Option[Integer] = scala
      .Option(impl.includedAllocatedStorage())
      .map(value => zio.aws.databasemigration.model.primitives.Integer(value))
    override val availabilityZones: Option[List[String]] = scala
      .Option(impl.availabilityZones())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
    override val releaseStatus
        : Option[zio.aws.databasemigration.model.ReleaseStatusValues] = scala
      .Option(impl.releaseStatus())
      .map(value =>
        zio.aws.databasemigration.model.ReleaseStatusValues.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.databasemigration.model.OrderableReplicationInstance
  ): zio.aws.databasemigration.model.OrderableReplicationInstance.ReadOnly =
    new Wrapper(impl)
}
