package zio.aws.databasemigration.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class DescribeReplicationInstancesResponse(
    marker: Option[String] = None,
    replicationInstances: Option[
      Iterable[zio.aws.databasemigration.model.ReplicationInstance]
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.databasemigration.model.DescribeReplicationInstancesResponse = {
    import DescribeReplicationInstancesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.databasemigration.model.DescribeReplicationInstancesResponse
      .builder()
      .optionallyWith(marker.map(value => value: java.lang.String))(_.marker)
      .optionallyWith(
        replicationInstances.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.replicationInstances)
      .build()
  }
  def asReadOnly
      : zio.aws.databasemigration.model.DescribeReplicationInstancesResponse.ReadOnly =
    zio.aws.databasemigration.model.DescribeReplicationInstancesResponse
      .wrap(buildAwsValue())
}
object DescribeReplicationInstancesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.databasemigration.model.DescribeReplicationInstancesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.databasemigration.model.DescribeReplicationInstancesResponse =
      zio.aws.databasemigration.model.DescribeReplicationInstancesResponse(
        marker.map(value => value),
        replicationInstances.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def marker: Option[String]
    def replicationInstances: Option[
      List[zio.aws.databasemigration.model.ReplicationInstance.ReadOnly]
    ]
    def getMarker: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("marker", marker)
    def getReplicationInstances: ZIO[Any, AwsError, List[
      zio.aws.databasemigration.model.ReplicationInstance.ReadOnly
    ]] =
      AwsError.unwrapOptionField("replicationInstances", replicationInstances)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.databasemigration.model.DescribeReplicationInstancesResponse
  ) extends zio.aws.databasemigration.model.DescribeReplicationInstancesResponse.ReadOnly {
    override val marker: Option[String] =
      scala.Option(impl.marker()).map(value => value: String)
    override val replicationInstances: Option[
      List[zio.aws.databasemigration.model.ReplicationInstance.ReadOnly]
    ] = scala
      .Option(impl.replicationInstances())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.databasemigration.model.ReplicationInstance.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.databasemigration.model.DescribeReplicationInstancesResponse
  ): zio.aws.databasemigration.model.DescribeReplicationInstancesResponse.ReadOnly =
    new Wrapper(impl)
}
