package zio.aws.databasemigration.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class EventCategoryGroup(
    sourceType: Option[String] = None,
    eventCategories: Option[Iterable[String]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.databasemigration.model.EventCategoryGroup = {
    import EventCategoryGroup.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.databasemigration.model.EventCategoryGroup
      .builder()
      .optionallyWith(sourceType.map(value => value: java.lang.String))(
        _.sourceType
      )
      .optionallyWith(
        eventCategories.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.eventCategories)
      .build()
  }
  def asReadOnly: zio.aws.databasemigration.model.EventCategoryGroup.ReadOnly =
    zio.aws.databasemigration.model.EventCategoryGroup.wrap(buildAwsValue())
}
object EventCategoryGroup {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.databasemigration.model.EventCategoryGroup
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.databasemigration.model.EventCategoryGroup =
      zio.aws.databasemigration.model.EventCategoryGroup(
        sourceType.map(value => value),
        eventCategories.map(value => value)
      )
    def sourceType: Option[String]
    def eventCategories: Option[List[String]]
    def getSourceType: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("sourceType", sourceType)
    def getEventCategories: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("eventCategories", eventCategories)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.databasemigration.model.EventCategoryGroup
  ) extends zio.aws.databasemigration.model.EventCategoryGroup.ReadOnly {
    override val sourceType: Option[String] =
      scala.Option(impl.sourceType()).map(value => value: String)
    override val eventCategories: Option[List[String]] = scala
      .Option(impl.eventCategories())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.databasemigration.model.EventCategoryGroup
  ): zio.aws.databasemigration.model.EventCategoryGroup.ReadOnly = new Wrapper(
    impl
  )
}
