package zio.aws.databasemigration.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class DeleteReplicationInstanceResponse(
    replicationInstance: Option[
      zio.aws.databasemigration.model.ReplicationInstance
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.databasemigration.model.DeleteReplicationInstanceResponse = {
    import DeleteReplicationInstanceResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.databasemigration.model.DeleteReplicationInstanceResponse
      .builder()
      .optionallyWith(replicationInstance.map(value => value.buildAwsValue()))(
        _.replicationInstance
      )
      .build()
  }
  def asReadOnly
      : zio.aws.databasemigration.model.DeleteReplicationInstanceResponse.ReadOnly =
    zio.aws.databasemigration.model.DeleteReplicationInstanceResponse
      .wrap(buildAwsValue())
}
object DeleteReplicationInstanceResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.databasemigration.model.DeleteReplicationInstanceResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.databasemigration.model.DeleteReplicationInstanceResponse =
      zio.aws.databasemigration.model.DeleteReplicationInstanceResponse(
        replicationInstance.map(value => value.asEditable)
      )
    def replicationInstance
        : Option[zio.aws.databasemigration.model.ReplicationInstance.ReadOnly]
    def getReplicationInstance: ZIO[
      Any,
      AwsError,
      zio.aws.databasemigration.model.ReplicationInstance.ReadOnly
    ] = AwsError.unwrapOptionField("replicationInstance", replicationInstance)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.databasemigration.model.DeleteReplicationInstanceResponse
  ) extends zio.aws.databasemigration.model.DeleteReplicationInstanceResponse.ReadOnly {
    override val replicationInstance
        : Option[zio.aws.databasemigration.model.ReplicationInstance.ReadOnly] =
      scala
        .Option(impl.replicationInstance())
        .map(value =>
          zio.aws.databasemigration.model.ReplicationInstance.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.databasemigration.model.DeleteReplicationInstanceResponse
  ): zio.aws.databasemigration.model.DeleteReplicationInstanceResponse.ReadOnly =
    new Wrapper(impl)
}
