package zio.aws.databasemigration.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import zio.aws.databasemigration.model.primitives.TStamp
import scala.jdk.CollectionConverters._
final case class RefreshSchemasStatus(
    endpointArn: Option[String] = None,
    replicationInstanceArn: Option[String] = None,
    status: Option[
      zio.aws.databasemigration.model.RefreshSchemasStatusTypeValue
    ] = None,
    lastRefreshDate: Option[TStamp] = None,
    lastFailureMessage: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.databasemigration.model.RefreshSchemasStatus = {
    import RefreshSchemasStatus.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.databasemigration.model.RefreshSchemasStatus
      .builder()
      .optionallyWith(endpointArn.map(value => value: java.lang.String))(
        _.endpointArn
      )
      .optionallyWith(
        replicationInstanceArn.map(value => value: java.lang.String)
      )(_.replicationInstanceArn)
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(
        lastRefreshDate.map(value => TStamp.unwrap(value): Instant)
      )(_.lastRefreshDate)
      .optionallyWith(lastFailureMessage.map(value => value: java.lang.String))(
        _.lastFailureMessage
      )
      .build()
  }
  def asReadOnly
      : zio.aws.databasemigration.model.RefreshSchemasStatus.ReadOnly =
    zio.aws.databasemigration.model.RefreshSchemasStatus.wrap(buildAwsValue())
}
object RefreshSchemasStatus {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.databasemigration.model.RefreshSchemasStatus
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.databasemigration.model.RefreshSchemasStatus =
      zio.aws.databasemigration.model.RefreshSchemasStatus(
        endpointArn.map(value => value),
        replicationInstanceArn.map(value => value),
        status.map(value => value),
        lastRefreshDate.map(value => value),
        lastFailureMessage.map(value => value)
      )
    def endpointArn: Option[String]
    def replicationInstanceArn: Option[String]
    def status
        : Option[zio.aws.databasemigration.model.RefreshSchemasStatusTypeValue]
    def lastRefreshDate: Option[TStamp]
    def lastFailureMessage: Option[String]
    def getEndpointArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("endpointArn", endpointArn)
    def getReplicationInstanceArn: ZIO[Any, AwsError, String] = AwsError
      .unwrapOptionField("replicationInstanceArn", replicationInstanceArn)
    def getStatus: ZIO[
      Any,
      AwsError,
      zio.aws.databasemigration.model.RefreshSchemasStatusTypeValue
    ] = AwsError.unwrapOptionField("status", status)
    def getLastRefreshDate: ZIO[Any, AwsError, TStamp] =
      AwsError.unwrapOptionField("lastRefreshDate", lastRefreshDate)
    def getLastFailureMessage: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("lastFailureMessage", lastFailureMessage)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.databasemigration.model.RefreshSchemasStatus
  ) extends zio.aws.databasemigration.model.RefreshSchemasStatus.ReadOnly {
    override val endpointArn: Option[String] =
      scala.Option(impl.endpointArn()).map(value => value: String)
    override val replicationInstanceArn: Option[String] =
      scala.Option(impl.replicationInstanceArn()).map(value => value: String)
    override val status: Option[
      zio.aws.databasemigration.model.RefreshSchemasStatusTypeValue
    ] = scala
      .Option(impl.status())
      .map(value =>
        zio.aws.databasemigration.model.RefreshSchemasStatusTypeValue
          .wrap(value)
      )
    override val lastRefreshDate: Option[TStamp] = scala
      .Option(impl.lastRefreshDate())
      .map(value => zio.aws.databasemigration.model.primitives.TStamp(value))
    override val lastFailureMessage: Option[String] =
      scala.Option(impl.lastFailureMessage()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.databasemigration.model.RefreshSchemasStatus
  ): zio.aws.databasemigration.model.RefreshSchemasStatus.ReadOnly =
    new Wrapper(impl)
}
