package zio.aws.databasemigration.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.databasemigration.model.primitives.{
  IntegerOptional,
  SecretString
}
import scala.jdk.CollectionConverters._
final case class MongoDbSettings(
    username: Option[String] = None,
    password: Option[SecretString] = None,
    serverName: Option[String] = None,
    port: Option[IntegerOptional] = None,
    databaseName: Option[String] = None,
    authType: Option[zio.aws.databasemigration.model.AuthTypeValue] = None,
    authMechanism: Option[zio.aws.databasemigration.model.AuthMechanismValue] =
      None,
    nestingLevel: Option[zio.aws.databasemigration.model.NestingLevelValue] =
      None,
    extractDocId: Option[String] = None,
    docsToInvestigate: Option[String] = None,
    authSource: Option[String] = None,
    kmsKeyId: Option[String] = None,
    secretsManagerAccessRoleArn: Option[String] = None,
    secretsManagerSecretId: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.databasemigration.model.MongoDbSettings = {
    import MongoDbSettings.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.databasemigration.model.MongoDbSettings
      .builder()
      .optionallyWith(username.map(value => value: java.lang.String))(
        _.username
      )
      .optionallyWith(
        password.map(value => SecretString.unwrap(value): java.lang.String)
      )(_.password)
      .optionallyWith(serverName.map(value => value: java.lang.String))(
        _.serverName
      )
      .optionallyWith(
        port.map(value => IntegerOptional.unwrap(value): Integer)
      )(_.port)
      .optionallyWith(databaseName.map(value => value: java.lang.String))(
        _.databaseName
      )
      .optionallyWith(authType.map(value => value.unwrap))(_.authType)
      .optionallyWith(authMechanism.map(value => value.unwrap))(_.authMechanism)
      .optionallyWith(nestingLevel.map(value => value.unwrap))(_.nestingLevel)
      .optionallyWith(extractDocId.map(value => value: java.lang.String))(
        _.extractDocId
      )
      .optionallyWith(docsToInvestigate.map(value => value: java.lang.String))(
        _.docsToInvestigate
      )
      .optionallyWith(authSource.map(value => value: java.lang.String))(
        _.authSource
      )
      .optionallyWith(kmsKeyId.map(value => value: java.lang.String))(
        _.kmsKeyId
      )
      .optionallyWith(
        secretsManagerAccessRoleArn.map(value => value: java.lang.String)
      )(_.secretsManagerAccessRoleArn)
      .optionallyWith(
        secretsManagerSecretId.map(value => value: java.lang.String)
      )(_.secretsManagerSecretId)
      .build()
  }
  def asReadOnly: zio.aws.databasemigration.model.MongoDbSettings.ReadOnly =
    zio.aws.databasemigration.model.MongoDbSettings.wrap(buildAwsValue())
}
object MongoDbSettings {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.databasemigration.model.MongoDbSettings
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.databasemigration.model.MongoDbSettings =
      zio.aws.databasemigration.model.MongoDbSettings(
        username.map(value => value),
        password.map(value => value),
        serverName.map(value => value),
        port.map(value => value),
        databaseName.map(value => value),
        authType.map(value => value),
        authMechanism.map(value => value),
        nestingLevel.map(value => value),
        extractDocId.map(value => value),
        docsToInvestigate.map(value => value),
        authSource.map(value => value),
        kmsKeyId.map(value => value),
        secretsManagerAccessRoleArn.map(value => value),
        secretsManagerSecretId.map(value => value)
      )
    def username: Option[String]
    def password: Option[SecretString]
    def serverName: Option[String]
    def port: Option[IntegerOptional]
    def databaseName: Option[String]
    def authType: Option[zio.aws.databasemigration.model.AuthTypeValue]
    def authMechanism
        : Option[zio.aws.databasemigration.model.AuthMechanismValue]
    def nestingLevel: Option[zio.aws.databasemigration.model.NestingLevelValue]
    def extractDocId: Option[String]
    def docsToInvestigate: Option[String]
    def authSource: Option[String]
    def kmsKeyId: Option[String]
    def secretsManagerAccessRoleArn: Option[String]
    def secretsManagerSecretId: Option[String]
    def getUsername: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("username", username)
    def getPassword: ZIO[Any, AwsError, SecretString] =
      AwsError.unwrapOptionField("password", password)
    def getServerName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("serverName", serverName)
    def getPort: ZIO[Any, AwsError, IntegerOptional] =
      AwsError.unwrapOptionField("port", port)
    def getDatabaseName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("databaseName", databaseName)
    def getAuthType
        : ZIO[Any, AwsError, zio.aws.databasemigration.model.AuthTypeValue] =
      AwsError.unwrapOptionField("authType", authType)
    def getAuthMechanism: ZIO[
      Any,
      AwsError,
      zio.aws.databasemigration.model.AuthMechanismValue
    ] = AwsError.unwrapOptionField("authMechanism", authMechanism)
    def getNestingLevel: ZIO[
      Any,
      AwsError,
      zio.aws.databasemigration.model.NestingLevelValue
    ] = AwsError.unwrapOptionField("nestingLevel", nestingLevel)
    def getExtractDocId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("extractDocId", extractDocId)
    def getDocsToInvestigate: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("docsToInvestigate", docsToInvestigate)
    def getAuthSource: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("authSource", authSource)
    def getKmsKeyId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("kmsKeyId", kmsKeyId)
    def getSecretsManagerAccessRoleArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField(
        "secretsManagerAccessRoleArn",
        secretsManagerAccessRoleArn
      )
    def getSecretsManagerSecretId: ZIO[Any, AwsError, String] = AwsError
      .unwrapOptionField("secretsManagerSecretId", secretsManagerSecretId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.databasemigration.model.MongoDbSettings
  ) extends zio.aws.databasemigration.model.MongoDbSettings.ReadOnly {
    override val username: Option[String] =
      scala.Option(impl.username()).map(value => value: String)
    override val password: Option[SecretString] = scala
      .Option(impl.password())
      .map(value =>
        zio.aws.databasemigration.model.primitives.SecretString(value)
      )
    override val serverName: Option[String] =
      scala.Option(impl.serverName()).map(value => value: String)
    override val port: Option[IntegerOptional] = scala
      .Option(impl.port())
      .map(value =>
        zio.aws.databasemigration.model.primitives.IntegerOptional(value)
      )
    override val databaseName: Option[String] =
      scala.Option(impl.databaseName()).map(value => value: String)
    override val authType
        : Option[zio.aws.databasemigration.model.AuthTypeValue] = scala
      .Option(impl.authType())
      .map(value => zio.aws.databasemigration.model.AuthTypeValue.wrap(value))
    override val authMechanism
        : Option[zio.aws.databasemigration.model.AuthMechanismValue] = scala
      .Option(impl.authMechanism())
      .map(value =>
        zio.aws.databasemigration.model.AuthMechanismValue.wrap(value)
      )
    override val nestingLevel
        : Option[zio.aws.databasemigration.model.NestingLevelValue] = scala
      .Option(impl.nestingLevel())
      .map(value =>
        zio.aws.databasemigration.model.NestingLevelValue.wrap(value)
      )
    override val extractDocId: Option[String] =
      scala.Option(impl.extractDocId()).map(value => value: String)
    override val docsToInvestigate: Option[String] =
      scala.Option(impl.docsToInvestigate()).map(value => value: String)
    override val authSource: Option[String] =
      scala.Option(impl.authSource()).map(value => value: String)
    override val kmsKeyId: Option[String] =
      scala.Option(impl.kmsKeyId()).map(value => value: String)
    override val secretsManagerAccessRoleArn: Option[String] = scala
      .Option(impl.secretsManagerAccessRoleArn())
      .map(value => value: String)
    override val secretsManagerSecretId: Option[String] =
      scala.Option(impl.secretsManagerSecretId()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.databasemigration.model.MongoDbSettings
  ): zio.aws.databasemigration.model.MongoDbSettings.ReadOnly = new Wrapper(
    impl
  )
}
