package zio.aws.databasemigration.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ModifyEventSubscriptionResponse(
    eventSubscription: Option[
      zio.aws.databasemigration.model.EventSubscription
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.databasemigration.model.ModifyEventSubscriptionResponse = {
    import ModifyEventSubscriptionResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.databasemigration.model.ModifyEventSubscriptionResponse
      .builder()
      .optionallyWith(eventSubscription.map(value => value.buildAwsValue()))(
        _.eventSubscription
      )
      .build()
  }
  def asReadOnly
      : zio.aws.databasemigration.model.ModifyEventSubscriptionResponse.ReadOnly =
    zio.aws.databasemigration.model.ModifyEventSubscriptionResponse
      .wrap(buildAwsValue())
}
object ModifyEventSubscriptionResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.databasemigration.model.ModifyEventSubscriptionResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.databasemigration.model.ModifyEventSubscriptionResponse =
      zio.aws.databasemigration.model.ModifyEventSubscriptionResponse(
        eventSubscription.map(value => value.asEditable)
      )
    def eventSubscription
        : Option[zio.aws.databasemigration.model.EventSubscription.ReadOnly]
    def getEventSubscription: ZIO[
      Any,
      AwsError,
      zio.aws.databasemigration.model.EventSubscription.ReadOnly
    ] = AwsError.unwrapOptionField("eventSubscription", eventSubscription)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.databasemigration.model.ModifyEventSubscriptionResponse
  ) extends zio.aws.databasemigration.model.ModifyEventSubscriptionResponse.ReadOnly {
    override val eventSubscription
        : Option[zio.aws.databasemigration.model.EventSubscription.ReadOnly] =
      scala
        .Option(impl.eventSubscription())
        .map(value =>
          zio.aws.databasemigration.model.EventSubscription.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.databasemigration.model.ModifyEventSubscriptionResponse
  ): zio.aws.databasemigration.model.ModifyEventSubscriptionResponse.ReadOnly =
    new Wrapper(impl)
}
