package zio.aws.databasemigration.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import zio.aws.databasemigration.model.primitives.TStamp
import scala.jdk.CollectionConverters._
final case class CreateReplicationTaskRequest(
    replicationTaskIdentifier: String,
    sourceEndpointArn: String,
    targetEndpointArn: String,
    replicationInstanceArn: String,
    migrationType: zio.aws.databasemigration.model.MigrationTypeValue,
    tableMappings: String,
    replicationTaskSettings: Option[String] = None,
    cdcStartTime: Option[TStamp] = None,
    cdcStartPosition: Option[String] = None,
    cdcStopPosition: Option[String] = None,
    tags: Option[Iterable[zio.aws.databasemigration.model.Tag]] = None,
    taskData: Option[String] = None,
    resourceIdentifier: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.databasemigration.model.CreateReplicationTaskRequest = {
    import CreateReplicationTaskRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.databasemigration.model.CreateReplicationTaskRequest
      .builder()
      .replicationTaskIdentifier(replicationTaskIdentifier: java.lang.String)
      .sourceEndpointArn(sourceEndpointArn: java.lang.String)
      .targetEndpointArn(targetEndpointArn: java.lang.String)
      .replicationInstanceArn(replicationInstanceArn: java.lang.String)
      .migrationType(migrationType.unwrap)
      .tableMappings(tableMappings: java.lang.String)
      .optionallyWith(
        replicationTaskSettings.map(value => value: java.lang.String)
      )(_.replicationTaskSettings)
      .optionallyWith(cdcStartTime.map(value => TStamp.unwrap(value): Instant))(
        _.cdcStartTime
      )
      .optionallyWith(cdcStartPosition.map(value => value: java.lang.String))(
        _.cdcStartPosition
      )
      .optionallyWith(cdcStopPosition.map(value => value: java.lang.String))(
        _.cdcStopPosition
      )
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .optionallyWith(taskData.map(value => value: java.lang.String))(
        _.taskData
      )
      .optionallyWith(resourceIdentifier.map(value => value: java.lang.String))(
        _.resourceIdentifier
      )
      .build()
  }
  def asReadOnly
      : zio.aws.databasemigration.model.CreateReplicationTaskRequest.ReadOnly =
    zio.aws.databasemigration.model.CreateReplicationTaskRequest
      .wrap(buildAwsValue())
}
object CreateReplicationTaskRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.databasemigration.model.CreateReplicationTaskRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.databasemigration.model.CreateReplicationTaskRequest =
      zio.aws.databasemigration.model.CreateReplicationTaskRequest(
        replicationTaskIdentifier,
        sourceEndpointArn,
        targetEndpointArn,
        replicationInstanceArn,
        migrationType,
        tableMappings,
        replicationTaskSettings.map(value => value),
        cdcStartTime.map(value => value),
        cdcStartPosition.map(value => value),
        cdcStopPosition.map(value => value),
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        taskData.map(value => value),
        resourceIdentifier.map(value => value)
      )
    def replicationTaskIdentifier: String
    def sourceEndpointArn: String
    def targetEndpointArn: String
    def replicationInstanceArn: String
    def migrationType: zio.aws.databasemigration.model.MigrationTypeValue
    def tableMappings: String
    def replicationTaskSettings: Option[String]
    def cdcStartTime: Option[TStamp]
    def cdcStartPosition: Option[String]
    def cdcStopPosition: Option[String]
    def tags: Option[List[zio.aws.databasemigration.model.Tag.ReadOnly]]
    def taskData: Option[String]
    def resourceIdentifier: Option[String]
    def getReplicationTaskIdentifier: ZIO[Any, Nothing, String] =
      ZIO.succeed(replicationTaskIdentifier)
    def getSourceEndpointArn: ZIO[Any, Nothing, String] =
      ZIO.succeed(sourceEndpointArn)
    def getTargetEndpointArn: ZIO[Any, Nothing, String] =
      ZIO.succeed(targetEndpointArn)
    def getReplicationInstanceArn: ZIO[Any, Nothing, String] =
      ZIO.succeed(replicationInstanceArn)
    def getMigrationType: ZIO[
      Any,
      Nothing,
      zio.aws.databasemigration.model.MigrationTypeValue
    ] = ZIO.succeed(migrationType)
    def getTableMappings: ZIO[Any, Nothing, String] = ZIO.succeed(tableMappings)
    def getReplicationTaskSettings: ZIO[Any, AwsError, String] = AwsError
      .unwrapOptionField("replicationTaskSettings", replicationTaskSettings)
    def getCdcStartTime: ZIO[Any, AwsError, TStamp] =
      AwsError.unwrapOptionField("cdcStartTime", cdcStartTime)
    def getCdcStartPosition: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("cdcStartPosition", cdcStartPosition)
    def getCdcStopPosition: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("cdcStopPosition", cdcStopPosition)
    def getTags: ZIO[Any, AwsError, List[
      zio.aws.databasemigration.model.Tag.ReadOnly
    ]] = AwsError.unwrapOptionField("tags", tags)
    def getTaskData: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("taskData", taskData)
    def getResourceIdentifier: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("resourceIdentifier", resourceIdentifier)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.databasemigration.model.CreateReplicationTaskRequest
  ) extends zio.aws.databasemigration.model.CreateReplicationTaskRequest.ReadOnly {
    override val replicationTaskIdentifier: String =
      impl.replicationTaskIdentifier(): String
    override val sourceEndpointArn: String = impl.sourceEndpointArn(): String
    override val targetEndpointArn: String = impl.targetEndpointArn(): String
    override val replicationInstanceArn: String =
      impl.replicationInstanceArn(): String
    override val migrationType
        : zio.aws.databasemigration.model.MigrationTypeValue =
      zio.aws.databasemigration.model.MigrationTypeValue
        .wrap(impl.migrationType())
    override val tableMappings: String = impl.tableMappings(): String
    override val replicationTaskSettings: Option[String] =
      scala.Option(impl.replicationTaskSettings()).map(value => value: String)
    override val cdcStartTime: Option[TStamp] = scala
      .Option(impl.cdcStartTime())
      .map(value => zio.aws.databasemigration.model.primitives.TStamp(value))
    override val cdcStartPosition: Option[String] =
      scala.Option(impl.cdcStartPosition()).map(value => value: String)
    override val cdcStopPosition: Option[String] =
      scala.Option(impl.cdcStopPosition()).map(value => value: String)
    override val tags
        : Option[List[zio.aws.databasemigration.model.Tag.ReadOnly]] = scala
      .Option(impl.tags())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.databasemigration.model.Tag.wrap(item)
        }.toList
      )
    override val taskData: Option[String] =
      scala.Option(impl.taskData()).map(value => value: String)
    override val resourceIdentifier: Option[String] =
      scala.Option(impl.resourceIdentifier()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.databasemigration.model.CreateReplicationTaskRequest
  ): zio.aws.databasemigration.model.CreateReplicationTaskRequest.ReadOnly =
    new Wrapper(impl)
}
