package zio.aws.databasemigration.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import zio.aws.databasemigration.model.primitives.TStamp
import scala.jdk.CollectionConverters._
final case class ReplicationTaskAssessmentResult(
    replicationTaskIdentifier: Option[String] = None,
    replicationTaskArn: Option[String] = None,
    replicationTaskLastAssessmentDate: Option[TStamp] = None,
    assessmentStatus: Option[String] = None,
    assessmentResultsFile: Option[String] = None,
    assessmentResults: Option[String] = None,
    s3ObjectUrl: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.databasemigration.model.ReplicationTaskAssessmentResult = {
    import ReplicationTaskAssessmentResult.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.databasemigration.model.ReplicationTaskAssessmentResult
      .builder()
      .optionallyWith(
        replicationTaskIdentifier.map(value => value: java.lang.String)
      )(_.replicationTaskIdentifier)
      .optionallyWith(replicationTaskArn.map(value => value: java.lang.String))(
        _.replicationTaskArn
      )
      .optionallyWith(
        replicationTaskLastAssessmentDate.map(value =>
          TStamp.unwrap(value): Instant
        )
      )(_.replicationTaskLastAssessmentDate)
      .optionallyWith(assessmentStatus.map(value => value: java.lang.String))(
        _.assessmentStatus
      )
      .optionallyWith(
        assessmentResultsFile.map(value => value: java.lang.String)
      )(_.assessmentResultsFile)
      .optionallyWith(assessmentResults.map(value => value: java.lang.String))(
        _.assessmentResults
      )
      .optionallyWith(s3ObjectUrl.map(value => value: java.lang.String))(
        _.s3ObjectUrl
      )
      .build()
  }
  def asReadOnly
      : zio.aws.databasemigration.model.ReplicationTaskAssessmentResult.ReadOnly =
    zio.aws.databasemigration.model.ReplicationTaskAssessmentResult
      .wrap(buildAwsValue())
}
object ReplicationTaskAssessmentResult {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.databasemigration.model.ReplicationTaskAssessmentResult
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.databasemigration.model.ReplicationTaskAssessmentResult =
      zio.aws.databasemigration.model.ReplicationTaskAssessmentResult(
        replicationTaskIdentifier.map(value => value),
        replicationTaskArn.map(value => value),
        replicationTaskLastAssessmentDate.map(value => value),
        assessmentStatus.map(value => value),
        assessmentResultsFile.map(value => value),
        assessmentResults.map(value => value),
        s3ObjectUrl.map(value => value)
      )
    def replicationTaskIdentifier: Option[String]
    def replicationTaskArn: Option[String]
    def replicationTaskLastAssessmentDate: Option[TStamp]
    def assessmentStatus: Option[String]
    def assessmentResultsFile: Option[String]
    def assessmentResults: Option[String]
    def s3ObjectUrl: Option[String]
    def getReplicationTaskIdentifier: ZIO[Any, AwsError, String] = AwsError
      .unwrapOptionField("replicationTaskIdentifier", replicationTaskIdentifier)
    def getReplicationTaskArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("replicationTaskArn", replicationTaskArn)
    def getReplicationTaskLastAssessmentDate: ZIO[Any, AwsError, TStamp] =
      AwsError.unwrapOptionField(
        "replicationTaskLastAssessmentDate",
        replicationTaskLastAssessmentDate
      )
    def getAssessmentStatus: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("assessmentStatus", assessmentStatus)
    def getAssessmentResultsFile: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("assessmentResultsFile", assessmentResultsFile)
    def getAssessmentResults: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("assessmentResults", assessmentResults)
    def getS3ObjectUrl: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("s3ObjectUrl", s3ObjectUrl)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.databasemigration.model.ReplicationTaskAssessmentResult
  ) extends zio.aws.databasemigration.model.ReplicationTaskAssessmentResult.ReadOnly {
    override val replicationTaskIdentifier: Option[String] =
      scala.Option(impl.replicationTaskIdentifier()).map(value => value: String)
    override val replicationTaskArn: Option[String] =
      scala.Option(impl.replicationTaskArn()).map(value => value: String)
    override val replicationTaskLastAssessmentDate: Option[TStamp] = scala
      .Option(impl.replicationTaskLastAssessmentDate())
      .map(value => zio.aws.databasemigration.model.primitives.TStamp(value))
    override val assessmentStatus: Option[String] =
      scala.Option(impl.assessmentStatus()).map(value => value: String)
    override val assessmentResultsFile: Option[String] =
      scala.Option(impl.assessmentResultsFile()).map(value => value: String)
    override val assessmentResults: Option[String] =
      scala.Option(impl.assessmentResults()).map(value => value: String)
    override val s3ObjectUrl: Option[String] =
      scala.Option(impl.s3ObjectUrl()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.databasemigration.model.ReplicationTaskAssessmentResult
  ): zio.aws.databasemigration.model.ReplicationTaskAssessmentResult.ReadOnly =
    new Wrapper(impl)
}
