package zio.aws.databasemigration.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.databasemigration.model.primitives.{
  SecretString,
  IntegerOptional,
  BooleanOptional
}
import scala.jdk.CollectionConverters._
final case class RedshiftSettings(
    acceptAnyDate: Option[BooleanOptional] = None,
    afterConnectScript: Option[String] = None,
    bucketFolder: Option[String] = None,
    bucketName: Option[String] = None,
    caseSensitiveNames: Option[BooleanOptional] = None,
    compUpdate: Option[BooleanOptional] = None,
    connectionTimeout: Option[IntegerOptional] = None,
    databaseName: Option[String] = None,
    dateFormat: Option[String] = None,
    emptyAsNull: Option[BooleanOptional] = None,
    encryptionMode: Option[
      zio.aws.databasemigration.model.EncryptionModeValue
    ] = None,
    explicitIds: Option[BooleanOptional] = None,
    fileTransferUploadStreams: Option[IntegerOptional] = None,
    loadTimeout: Option[IntegerOptional] = None,
    maxFileSize: Option[IntegerOptional] = None,
    password: Option[SecretString] = None,
    port: Option[IntegerOptional] = None,
    removeQuotes: Option[BooleanOptional] = None,
    replaceInvalidChars: Option[String] = None,
    replaceChars: Option[String] = None,
    serverName: Option[String] = None,
    serviceAccessRoleArn: Option[String] = None,
    serverSideEncryptionKmsKeyId: Option[String] = None,
    timeFormat: Option[String] = None,
    trimBlanks: Option[BooleanOptional] = None,
    truncateColumns: Option[BooleanOptional] = None,
    username: Option[String] = None,
    writeBufferSize: Option[IntegerOptional] = None,
    secretsManagerAccessRoleArn: Option[String] = None,
    secretsManagerSecretId: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.databasemigration.model.RedshiftSettings = {
    import RedshiftSettings.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.databasemigration.model.RedshiftSettings
      .builder()
      .optionallyWith(
        acceptAnyDate.map(value =>
          BooleanOptional.unwrap(value): java.lang.Boolean
        )
      )(_.acceptAnyDate)
      .optionallyWith(afterConnectScript.map(value => value: java.lang.String))(
        _.afterConnectScript
      )
      .optionallyWith(bucketFolder.map(value => value: java.lang.String))(
        _.bucketFolder
      )
      .optionallyWith(bucketName.map(value => value: java.lang.String))(
        _.bucketName
      )
      .optionallyWith(
        caseSensitiveNames.map(value =>
          BooleanOptional.unwrap(value): java.lang.Boolean
        )
      )(_.caseSensitiveNames)
      .optionallyWith(
        compUpdate.map(value =>
          BooleanOptional.unwrap(value): java.lang.Boolean
        )
      )(_.compUpdate)
      .optionallyWith(
        connectionTimeout.map(value => IntegerOptional.unwrap(value): Integer)
      )(_.connectionTimeout)
      .optionallyWith(databaseName.map(value => value: java.lang.String))(
        _.databaseName
      )
      .optionallyWith(dateFormat.map(value => value: java.lang.String))(
        _.dateFormat
      )
      .optionallyWith(
        emptyAsNull.map(value =>
          BooleanOptional.unwrap(value): java.lang.Boolean
        )
      )(_.emptyAsNull)
      .optionallyWith(encryptionMode.map(value => value.unwrap))(
        _.encryptionMode
      )
      .optionallyWith(
        explicitIds.map(value =>
          BooleanOptional.unwrap(value): java.lang.Boolean
        )
      )(_.explicitIds)
      .optionallyWith(
        fileTransferUploadStreams.map(value =>
          IntegerOptional.unwrap(value): Integer
        )
      )(_.fileTransferUploadStreams)
      .optionallyWith(
        loadTimeout.map(value => IntegerOptional.unwrap(value): Integer)
      )(_.loadTimeout)
      .optionallyWith(
        maxFileSize.map(value => IntegerOptional.unwrap(value): Integer)
      )(_.maxFileSize)
      .optionallyWith(
        password.map(value => SecretString.unwrap(value): java.lang.String)
      )(_.password)
      .optionallyWith(
        port.map(value => IntegerOptional.unwrap(value): Integer)
      )(_.port)
      .optionallyWith(
        removeQuotes.map(value =>
          BooleanOptional.unwrap(value): java.lang.Boolean
        )
      )(_.removeQuotes)
      .optionallyWith(
        replaceInvalidChars.map(value => value: java.lang.String)
      )(_.replaceInvalidChars)
      .optionallyWith(replaceChars.map(value => value: java.lang.String))(
        _.replaceChars
      )
      .optionallyWith(serverName.map(value => value: java.lang.String))(
        _.serverName
      )
      .optionallyWith(
        serviceAccessRoleArn.map(value => value: java.lang.String)
      )(_.serviceAccessRoleArn)
      .optionallyWith(
        serverSideEncryptionKmsKeyId.map(value => value: java.lang.String)
      )(_.serverSideEncryptionKmsKeyId)
      .optionallyWith(timeFormat.map(value => value: java.lang.String))(
        _.timeFormat
      )
      .optionallyWith(
        trimBlanks.map(value =>
          BooleanOptional.unwrap(value): java.lang.Boolean
        )
      )(_.trimBlanks)
      .optionallyWith(
        truncateColumns.map(value =>
          BooleanOptional.unwrap(value): java.lang.Boolean
        )
      )(_.truncateColumns)
      .optionallyWith(username.map(value => value: java.lang.String))(
        _.username
      )
      .optionallyWith(
        writeBufferSize.map(value => IntegerOptional.unwrap(value): Integer)
      )(_.writeBufferSize)
      .optionallyWith(
        secretsManagerAccessRoleArn.map(value => value: java.lang.String)
      )(_.secretsManagerAccessRoleArn)
      .optionallyWith(
        secretsManagerSecretId.map(value => value: java.lang.String)
      )(_.secretsManagerSecretId)
      .build()
  }
  def asReadOnly: zio.aws.databasemigration.model.RedshiftSettings.ReadOnly =
    zio.aws.databasemigration.model.RedshiftSettings.wrap(buildAwsValue())
}
object RedshiftSettings {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.databasemigration.model.RedshiftSettings
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.databasemigration.model.RedshiftSettings =
      zio.aws.databasemigration.model.RedshiftSettings(
        acceptAnyDate.map(value => value),
        afterConnectScript.map(value => value),
        bucketFolder.map(value => value),
        bucketName.map(value => value),
        caseSensitiveNames.map(value => value),
        compUpdate.map(value => value),
        connectionTimeout.map(value => value),
        databaseName.map(value => value),
        dateFormat.map(value => value),
        emptyAsNull.map(value => value),
        encryptionMode.map(value => value),
        explicitIds.map(value => value),
        fileTransferUploadStreams.map(value => value),
        loadTimeout.map(value => value),
        maxFileSize.map(value => value),
        password.map(value => value),
        port.map(value => value),
        removeQuotes.map(value => value),
        replaceInvalidChars.map(value => value),
        replaceChars.map(value => value),
        serverName.map(value => value),
        serviceAccessRoleArn.map(value => value),
        serverSideEncryptionKmsKeyId.map(value => value),
        timeFormat.map(value => value),
        trimBlanks.map(value => value),
        truncateColumns.map(value => value),
        username.map(value => value),
        writeBufferSize.map(value => value),
        secretsManagerAccessRoleArn.map(value => value),
        secretsManagerSecretId.map(value => value)
      )
    def acceptAnyDate: Option[BooleanOptional]
    def afterConnectScript: Option[String]
    def bucketFolder: Option[String]
    def bucketName: Option[String]
    def caseSensitiveNames: Option[BooleanOptional]
    def compUpdate: Option[BooleanOptional]
    def connectionTimeout: Option[IntegerOptional]
    def databaseName: Option[String]
    def dateFormat: Option[String]
    def emptyAsNull: Option[BooleanOptional]
    def encryptionMode
        : Option[zio.aws.databasemigration.model.EncryptionModeValue]
    def explicitIds: Option[BooleanOptional]
    def fileTransferUploadStreams: Option[IntegerOptional]
    def loadTimeout: Option[IntegerOptional]
    def maxFileSize: Option[IntegerOptional]
    def password: Option[SecretString]
    def port: Option[IntegerOptional]
    def removeQuotes: Option[BooleanOptional]
    def replaceInvalidChars: Option[String]
    def replaceChars: Option[String]
    def serverName: Option[String]
    def serviceAccessRoleArn: Option[String]
    def serverSideEncryptionKmsKeyId: Option[String]
    def timeFormat: Option[String]
    def trimBlanks: Option[BooleanOptional]
    def truncateColumns: Option[BooleanOptional]
    def username: Option[String]
    def writeBufferSize: Option[IntegerOptional]
    def secretsManagerAccessRoleArn: Option[String]
    def secretsManagerSecretId: Option[String]
    def getAcceptAnyDate: ZIO[Any, AwsError, BooleanOptional] =
      AwsError.unwrapOptionField("acceptAnyDate", acceptAnyDate)
    def getAfterConnectScript: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("afterConnectScript", afterConnectScript)
    def getBucketFolder: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("bucketFolder", bucketFolder)
    def getBucketName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("bucketName", bucketName)
    def getCaseSensitiveNames: ZIO[Any, AwsError, BooleanOptional] =
      AwsError.unwrapOptionField("caseSensitiveNames", caseSensitiveNames)
    def getCompUpdate: ZIO[Any, AwsError, BooleanOptional] =
      AwsError.unwrapOptionField("compUpdate", compUpdate)
    def getConnectionTimeout: ZIO[Any, AwsError, IntegerOptional] =
      AwsError.unwrapOptionField("connectionTimeout", connectionTimeout)
    def getDatabaseName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("databaseName", databaseName)
    def getDateFormat: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("dateFormat", dateFormat)
    def getEmptyAsNull: ZIO[Any, AwsError, BooleanOptional] =
      AwsError.unwrapOptionField("emptyAsNull", emptyAsNull)
    def getEncryptionMode: ZIO[
      Any,
      AwsError,
      zio.aws.databasemigration.model.EncryptionModeValue
    ] = AwsError.unwrapOptionField("encryptionMode", encryptionMode)
    def getExplicitIds: ZIO[Any, AwsError, BooleanOptional] =
      AwsError.unwrapOptionField("explicitIds", explicitIds)
    def getFileTransferUploadStreams: ZIO[Any, AwsError, IntegerOptional] =
      AwsError.unwrapOptionField(
        "fileTransferUploadStreams",
        fileTransferUploadStreams
      )
    def getLoadTimeout: ZIO[Any, AwsError, IntegerOptional] =
      AwsError.unwrapOptionField("loadTimeout", loadTimeout)
    def getMaxFileSize: ZIO[Any, AwsError, IntegerOptional] =
      AwsError.unwrapOptionField("maxFileSize", maxFileSize)
    def getPassword: ZIO[Any, AwsError, SecretString] =
      AwsError.unwrapOptionField("password", password)
    def getPort: ZIO[Any, AwsError, IntegerOptional] =
      AwsError.unwrapOptionField("port", port)
    def getRemoveQuotes: ZIO[Any, AwsError, BooleanOptional] =
      AwsError.unwrapOptionField("removeQuotes", removeQuotes)
    def getReplaceInvalidChars: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("replaceInvalidChars", replaceInvalidChars)
    def getReplaceChars: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("replaceChars", replaceChars)
    def getServerName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("serverName", serverName)
    def getServiceAccessRoleArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("serviceAccessRoleArn", serviceAccessRoleArn)
    def getServerSideEncryptionKmsKeyId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField(
        "serverSideEncryptionKmsKeyId",
        serverSideEncryptionKmsKeyId
      )
    def getTimeFormat: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("timeFormat", timeFormat)
    def getTrimBlanks: ZIO[Any, AwsError, BooleanOptional] =
      AwsError.unwrapOptionField("trimBlanks", trimBlanks)
    def getTruncateColumns: ZIO[Any, AwsError, BooleanOptional] =
      AwsError.unwrapOptionField("truncateColumns", truncateColumns)
    def getUsername: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("username", username)
    def getWriteBufferSize: ZIO[Any, AwsError, IntegerOptional] =
      AwsError.unwrapOptionField("writeBufferSize", writeBufferSize)
    def getSecretsManagerAccessRoleArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField(
        "secretsManagerAccessRoleArn",
        secretsManagerAccessRoleArn
      )
    def getSecretsManagerSecretId: ZIO[Any, AwsError, String] = AwsError
      .unwrapOptionField("secretsManagerSecretId", secretsManagerSecretId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.databasemigration.model.RedshiftSettings
  ) extends zio.aws.databasemigration.model.RedshiftSettings.ReadOnly {
    override val acceptAnyDate: Option[BooleanOptional] = scala
      .Option(impl.acceptAnyDate())
      .map(value =>
        zio.aws.databasemigration.model.primitives.BooleanOptional(value)
      )
    override val afterConnectScript: Option[String] =
      scala.Option(impl.afterConnectScript()).map(value => value: String)
    override val bucketFolder: Option[String] =
      scala.Option(impl.bucketFolder()).map(value => value: String)
    override val bucketName: Option[String] =
      scala.Option(impl.bucketName()).map(value => value: String)
    override val caseSensitiveNames: Option[BooleanOptional] = scala
      .Option(impl.caseSensitiveNames())
      .map(value =>
        zio.aws.databasemigration.model.primitives.BooleanOptional(value)
      )
    override val compUpdate: Option[BooleanOptional] = scala
      .Option(impl.compUpdate())
      .map(value =>
        zio.aws.databasemigration.model.primitives.BooleanOptional(value)
      )
    override val connectionTimeout: Option[IntegerOptional] = scala
      .Option(impl.connectionTimeout())
      .map(value =>
        zio.aws.databasemigration.model.primitives.IntegerOptional(value)
      )
    override val databaseName: Option[String] =
      scala.Option(impl.databaseName()).map(value => value: String)
    override val dateFormat: Option[String] =
      scala.Option(impl.dateFormat()).map(value => value: String)
    override val emptyAsNull: Option[BooleanOptional] = scala
      .Option(impl.emptyAsNull())
      .map(value =>
        zio.aws.databasemigration.model.primitives.BooleanOptional(value)
      )
    override val encryptionMode
        : Option[zio.aws.databasemigration.model.EncryptionModeValue] = scala
      .Option(impl.encryptionMode())
      .map(value =>
        zio.aws.databasemigration.model.EncryptionModeValue.wrap(value)
      )
    override val explicitIds: Option[BooleanOptional] = scala
      .Option(impl.explicitIds())
      .map(value =>
        zio.aws.databasemigration.model.primitives.BooleanOptional(value)
      )
    override val fileTransferUploadStreams: Option[IntegerOptional] = scala
      .Option(impl.fileTransferUploadStreams())
      .map(value =>
        zio.aws.databasemigration.model.primitives.IntegerOptional(value)
      )
    override val loadTimeout: Option[IntegerOptional] = scala
      .Option(impl.loadTimeout())
      .map(value =>
        zio.aws.databasemigration.model.primitives.IntegerOptional(value)
      )
    override val maxFileSize: Option[IntegerOptional] = scala
      .Option(impl.maxFileSize())
      .map(value =>
        zio.aws.databasemigration.model.primitives.IntegerOptional(value)
      )
    override val password: Option[SecretString] = scala
      .Option(impl.password())
      .map(value =>
        zio.aws.databasemigration.model.primitives.SecretString(value)
      )
    override val port: Option[IntegerOptional] = scala
      .Option(impl.port())
      .map(value =>
        zio.aws.databasemigration.model.primitives.IntegerOptional(value)
      )
    override val removeQuotes: Option[BooleanOptional] = scala
      .Option(impl.removeQuotes())
      .map(value =>
        zio.aws.databasemigration.model.primitives.BooleanOptional(value)
      )
    override val replaceInvalidChars: Option[String] =
      scala.Option(impl.replaceInvalidChars()).map(value => value: String)
    override val replaceChars: Option[String] =
      scala.Option(impl.replaceChars()).map(value => value: String)
    override val serverName: Option[String] =
      scala.Option(impl.serverName()).map(value => value: String)
    override val serviceAccessRoleArn: Option[String] =
      scala.Option(impl.serviceAccessRoleArn()).map(value => value: String)
    override val serverSideEncryptionKmsKeyId: Option[String] = scala
      .Option(impl.serverSideEncryptionKmsKeyId())
      .map(value => value: String)
    override val timeFormat: Option[String] =
      scala.Option(impl.timeFormat()).map(value => value: String)
    override val trimBlanks: Option[BooleanOptional] = scala
      .Option(impl.trimBlanks())
      .map(value =>
        zio.aws.databasemigration.model.primitives.BooleanOptional(value)
      )
    override val truncateColumns: Option[BooleanOptional] = scala
      .Option(impl.truncateColumns())
      .map(value =>
        zio.aws.databasemigration.model.primitives.BooleanOptional(value)
      )
    override val username: Option[String] =
      scala.Option(impl.username()).map(value => value: String)
    override val writeBufferSize: Option[IntegerOptional] = scala
      .Option(impl.writeBufferSize())
      .map(value =>
        zio.aws.databasemigration.model.primitives.IntegerOptional(value)
      )
    override val secretsManagerAccessRoleArn: Option[String] = scala
      .Option(impl.secretsManagerAccessRoleArn())
      .map(value => value: String)
    override val secretsManagerSecretId: Option[String] =
      scala.Option(impl.secretsManagerSecretId()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.databasemigration.model.RedshiftSettings
  ): zio.aws.databasemigration.model.RedshiftSettings.ReadOnly = new Wrapper(
    impl
  )
}
