package zio.aws.databasemigration.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class DescribeReplicationTaskAssessmentRunsResponse(
    marker: Option[String] = None,
    replicationTaskAssessmentRuns: Option[
      Iterable[zio.aws.databasemigration.model.ReplicationTaskAssessmentRun]
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.databasemigration.model.DescribeReplicationTaskAssessmentRunsResponse = {
    import DescribeReplicationTaskAssessmentRunsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.databasemigration.model.DescribeReplicationTaskAssessmentRunsResponse
      .builder()
      .optionallyWith(marker.map(value => value: java.lang.String))(_.marker)
      .optionallyWith(
        replicationTaskAssessmentRuns.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.replicationTaskAssessmentRuns)
      .build()
  }
  def asReadOnly
      : zio.aws.databasemigration.model.DescribeReplicationTaskAssessmentRunsResponse.ReadOnly =
    zio.aws.databasemigration.model.DescribeReplicationTaskAssessmentRunsResponse
      .wrap(buildAwsValue())
}
object DescribeReplicationTaskAssessmentRunsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.databasemigration.model.DescribeReplicationTaskAssessmentRunsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.databasemigration.model.DescribeReplicationTaskAssessmentRunsResponse =
      zio.aws.databasemigration.model
        .DescribeReplicationTaskAssessmentRunsResponse(
          marker.map(value => value),
          replicationTaskAssessmentRuns.map(value =>
            value.map { item =>
              item.asEditable
            }
          )
        )
    def marker: Option[String]
    def replicationTaskAssessmentRuns: Option[List[
      zio.aws.databasemigration.model.ReplicationTaskAssessmentRun.ReadOnly
    ]]
    def getMarker: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("marker", marker)
    def getReplicationTaskAssessmentRuns: ZIO[Any, AwsError, List[
      zio.aws.databasemigration.model.ReplicationTaskAssessmentRun.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "replicationTaskAssessmentRuns",
      replicationTaskAssessmentRuns
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.databasemigration.model.DescribeReplicationTaskAssessmentRunsResponse
  ) extends zio.aws.databasemigration.model.DescribeReplicationTaskAssessmentRunsResponse.ReadOnly {
    override val marker: Option[String] =
      scala.Option(impl.marker()).map(value => value: String)
    override val replicationTaskAssessmentRuns: Option[List[
      zio.aws.databasemigration.model.ReplicationTaskAssessmentRun.ReadOnly
    ]] = scala
      .Option(impl.replicationTaskAssessmentRuns())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.databasemigration.model.ReplicationTaskAssessmentRun
            .wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.databasemigration.model.DescribeReplicationTaskAssessmentRunsResponse
  ): zio.aws.databasemigration.model.DescribeReplicationTaskAssessmentRunsResponse.ReadOnly =
    new Wrapper(impl)
}
