package zio.aws.databasemigration.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class DeleteEventSubscriptionResponse(
    eventSubscription: Option[
      zio.aws.databasemigration.model.EventSubscription
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.databasemigration.model.DeleteEventSubscriptionResponse = {
    import DeleteEventSubscriptionResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.databasemigration.model.DeleteEventSubscriptionResponse
      .builder()
      .optionallyWith(eventSubscription.map(value => value.buildAwsValue()))(
        _.eventSubscription
      )
      .build()
  }
  def asReadOnly
      : zio.aws.databasemigration.model.DeleteEventSubscriptionResponse.ReadOnly =
    zio.aws.databasemigration.model.DeleteEventSubscriptionResponse
      .wrap(buildAwsValue())
}
object DeleteEventSubscriptionResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.databasemigration.model.DeleteEventSubscriptionResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.databasemigration.model.DeleteEventSubscriptionResponse =
      zio.aws.databasemigration.model.DeleteEventSubscriptionResponse(
        eventSubscription.map(value => value.asEditable)
      )
    def eventSubscription
        : Option[zio.aws.databasemigration.model.EventSubscription.ReadOnly]
    def getEventSubscription: ZIO[
      Any,
      AwsError,
      zio.aws.databasemigration.model.EventSubscription.ReadOnly
    ] = AwsError.unwrapOptionField("eventSubscription", eventSubscription)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.databasemigration.model.DeleteEventSubscriptionResponse
  ) extends zio.aws.databasemigration.model.DeleteEventSubscriptionResponse.ReadOnly {
    override val eventSubscription
        : Option[zio.aws.databasemigration.model.EventSubscription.ReadOnly] =
      scala
        .Option(impl.eventSubscription())
        .map(value =>
          zio.aws.databasemigration.model.EventSubscription.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.databasemigration.model.DeleteEventSubscriptionResponse
  ): zio.aws.databasemigration.model.DeleteEventSubscriptionResponse.ReadOnly =
    new Wrapper(impl)
}
