package zio.aws.databasemigration.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class DeleteCertificateResponse(
    certificate: Option[zio.aws.databasemigration.model.Certificate] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.databasemigration.model.DeleteCertificateResponse = {
    import DeleteCertificateResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.databasemigration.model.DeleteCertificateResponse
      .builder()
      .optionallyWith(certificate.map(value => value.buildAwsValue()))(
        _.certificate
      )
      .build()
  }
  def asReadOnly
      : zio.aws.databasemigration.model.DeleteCertificateResponse.ReadOnly =
    zio.aws.databasemigration.model.DeleteCertificateResponse
      .wrap(buildAwsValue())
}
object DeleteCertificateResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.databasemigration.model.DeleteCertificateResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.databasemigration.model.DeleteCertificateResponse =
      zio.aws.databasemigration.model
        .DeleteCertificateResponse(certificate.map(value => value.asEditable))
    def certificate
        : Option[zio.aws.databasemigration.model.Certificate.ReadOnly]
    def getCertificate: ZIO[
      Any,
      AwsError,
      zio.aws.databasemigration.model.Certificate.ReadOnly
    ] = AwsError.unwrapOptionField("certificate", certificate)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.databasemigration.model.DeleteCertificateResponse
  ) extends zio.aws.databasemigration.model.DeleteCertificateResponse.ReadOnly {
    override val certificate
        : Option[zio.aws.databasemigration.model.Certificate.ReadOnly] = scala
      .Option(impl.certificate())
      .map(value => zio.aws.databasemigration.model.Certificate.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.databasemigration.model.DeleteCertificateResponse
  ): zio.aws.databasemigration.model.DeleteCertificateResponse.ReadOnly =
    new Wrapper(impl)
}
