package zio.aws.databasemigration.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.databasemigration.model.primitives.{
  BooleanOptional,
  IntegerOptional
}
import scala.jdk.CollectionConverters._
final case class CreateReplicationInstanceRequest(
    replicationInstanceIdentifier: String,
    allocatedStorage: Option[IntegerOptional] = None,
    replicationInstanceClass: String,
    vpcSecurityGroupIds: Option[Iterable[String]] = None,
    availabilityZone: Option[String] = None,
    replicationSubnetGroupIdentifier: Option[String] = None,
    preferredMaintenanceWindow: Option[String] = None,
    multiAZ: Option[BooleanOptional] = None,
    engineVersion: Option[String] = None,
    autoMinorVersionUpgrade: Option[BooleanOptional] = None,
    tags: Option[Iterable[zio.aws.databasemigration.model.Tag]] = None,
    kmsKeyId: Option[String] = None,
    publiclyAccessible: Option[BooleanOptional] = None,
    dnsNameServers: Option[String] = None,
    resourceIdentifier: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.databasemigration.model.CreateReplicationInstanceRequest = {
    import CreateReplicationInstanceRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.databasemigration.model.CreateReplicationInstanceRequest
      .builder()
      .replicationInstanceIdentifier(
        replicationInstanceIdentifier: java.lang.String
      )
      .optionallyWith(
        allocatedStorage.map(value => IntegerOptional.unwrap(value): Integer)
      )(_.allocatedStorage)
      .replicationInstanceClass(replicationInstanceClass: java.lang.String)
      .optionallyWith(
        vpcSecurityGroupIds.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.vpcSecurityGroupIds)
      .optionallyWith(availabilityZone.map(value => value: java.lang.String))(
        _.availabilityZone
      )
      .optionallyWith(
        replicationSubnetGroupIdentifier.map(value => value: java.lang.String)
      )(_.replicationSubnetGroupIdentifier)
      .optionallyWith(
        preferredMaintenanceWindow.map(value => value: java.lang.String)
      )(_.preferredMaintenanceWindow)
      .optionallyWith(
        multiAZ.map(value => BooleanOptional.unwrap(value): java.lang.Boolean)
      )(_.multiAZ)
      .optionallyWith(engineVersion.map(value => value: java.lang.String))(
        _.engineVersion
      )
      .optionallyWith(
        autoMinorVersionUpgrade.map(value =>
          BooleanOptional.unwrap(value): java.lang.Boolean
        )
      )(_.autoMinorVersionUpgrade)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .optionallyWith(kmsKeyId.map(value => value: java.lang.String))(
        _.kmsKeyId
      )
      .optionallyWith(
        publiclyAccessible.map(value =>
          BooleanOptional.unwrap(value): java.lang.Boolean
        )
      )(_.publiclyAccessible)
      .optionallyWith(dnsNameServers.map(value => value: java.lang.String))(
        _.dnsNameServers
      )
      .optionallyWith(resourceIdentifier.map(value => value: java.lang.String))(
        _.resourceIdentifier
      )
      .build()
  }
  def asReadOnly
      : zio.aws.databasemigration.model.CreateReplicationInstanceRequest.ReadOnly =
    zio.aws.databasemigration.model.CreateReplicationInstanceRequest
      .wrap(buildAwsValue())
}
object CreateReplicationInstanceRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.databasemigration.model.CreateReplicationInstanceRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.databasemigration.model.CreateReplicationInstanceRequest =
      zio.aws.databasemigration.model.CreateReplicationInstanceRequest(
        replicationInstanceIdentifier,
        allocatedStorage.map(value => value),
        replicationInstanceClass,
        vpcSecurityGroupIds.map(value => value),
        availabilityZone.map(value => value),
        replicationSubnetGroupIdentifier.map(value => value),
        preferredMaintenanceWindow.map(value => value),
        multiAZ.map(value => value),
        engineVersion.map(value => value),
        autoMinorVersionUpgrade.map(value => value),
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        kmsKeyId.map(value => value),
        publiclyAccessible.map(value => value),
        dnsNameServers.map(value => value),
        resourceIdentifier.map(value => value)
      )
    def replicationInstanceIdentifier: String
    def allocatedStorage: Option[IntegerOptional]
    def replicationInstanceClass: String
    def vpcSecurityGroupIds: Option[List[String]]
    def availabilityZone: Option[String]
    def replicationSubnetGroupIdentifier: Option[String]
    def preferredMaintenanceWindow: Option[String]
    def multiAZ: Option[BooleanOptional]
    def engineVersion: Option[String]
    def autoMinorVersionUpgrade: Option[BooleanOptional]
    def tags: Option[List[zio.aws.databasemigration.model.Tag.ReadOnly]]
    def kmsKeyId: Option[String]
    def publiclyAccessible: Option[BooleanOptional]
    def dnsNameServers: Option[String]
    def resourceIdentifier: Option[String]
    def getReplicationInstanceIdentifier: ZIO[Any, Nothing, String] =
      ZIO.succeed(replicationInstanceIdentifier)
    def getAllocatedStorage: ZIO[Any, AwsError, IntegerOptional] =
      AwsError.unwrapOptionField("allocatedStorage", allocatedStorage)
    def getReplicationInstanceClass: ZIO[Any, Nothing, String] =
      ZIO.succeed(replicationInstanceClass)
    def getVpcSecurityGroupIds: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("vpcSecurityGroupIds", vpcSecurityGroupIds)
    def getAvailabilityZone: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("availabilityZone", availabilityZone)
    def getReplicationSubnetGroupIdentifier: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField(
        "replicationSubnetGroupIdentifier",
        replicationSubnetGroupIdentifier
      )
    def getPreferredMaintenanceWindow: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField(
        "preferredMaintenanceWindow",
        preferredMaintenanceWindow
      )
    def getMultiAZ: ZIO[Any, AwsError, BooleanOptional] =
      AwsError.unwrapOptionField("multiAZ", multiAZ)
    def getEngineVersion: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("engineVersion", engineVersion)
    def getAutoMinorVersionUpgrade: ZIO[Any, AwsError, BooleanOptional] =
      AwsError.unwrapOptionField(
        "autoMinorVersionUpgrade",
        autoMinorVersionUpgrade
      )
    def getTags: ZIO[Any, AwsError, List[
      zio.aws.databasemigration.model.Tag.ReadOnly
    ]] = AwsError.unwrapOptionField("tags", tags)
    def getKmsKeyId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("kmsKeyId", kmsKeyId)
    def getPubliclyAccessible: ZIO[Any, AwsError, BooleanOptional] =
      AwsError.unwrapOptionField("publiclyAccessible", publiclyAccessible)
    def getDnsNameServers: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("dnsNameServers", dnsNameServers)
    def getResourceIdentifier: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("resourceIdentifier", resourceIdentifier)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.databasemigration.model.CreateReplicationInstanceRequest
  ) extends zio.aws.databasemigration.model.CreateReplicationInstanceRequest.ReadOnly {
    override val replicationInstanceIdentifier: String =
      impl.replicationInstanceIdentifier(): String
    override val allocatedStorage: Option[IntegerOptional] = scala
      .Option(impl.allocatedStorage())
      .map(value =>
        zio.aws.databasemigration.model.primitives.IntegerOptional(value)
      )
    override val replicationInstanceClass: String =
      impl.replicationInstanceClass(): String
    override val vpcSecurityGroupIds: Option[List[String]] = scala
      .Option(impl.vpcSecurityGroupIds())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
    override val availabilityZone: Option[String] =
      scala.Option(impl.availabilityZone()).map(value => value: String)
    override val replicationSubnetGroupIdentifier: Option[String] = scala
      .Option(impl.replicationSubnetGroupIdentifier())
      .map(value => value: String)
    override val preferredMaintenanceWindow: Option[String] = scala
      .Option(impl.preferredMaintenanceWindow())
      .map(value => value: String)
    override val multiAZ: Option[BooleanOptional] = scala
      .Option(impl.multiAZ())
      .map(value =>
        zio.aws.databasemigration.model.primitives.BooleanOptional(value)
      )
    override val engineVersion: Option[String] =
      scala.Option(impl.engineVersion()).map(value => value: String)
    override val autoMinorVersionUpgrade: Option[BooleanOptional] = scala
      .Option(impl.autoMinorVersionUpgrade())
      .map(value =>
        zio.aws.databasemigration.model.primitives.BooleanOptional(value)
      )
    override val tags
        : Option[List[zio.aws.databasemigration.model.Tag.ReadOnly]] = scala
      .Option(impl.tags())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.databasemigration.model.Tag.wrap(item)
        }.toList
      )
    override val kmsKeyId: Option[String] =
      scala.Option(impl.kmsKeyId()).map(value => value: String)
    override val publiclyAccessible: Option[BooleanOptional] = scala
      .Option(impl.publiclyAccessible())
      .map(value =>
        zio.aws.databasemigration.model.primitives.BooleanOptional(value)
      )
    override val dnsNameServers: Option[String] =
      scala.Option(impl.dnsNameServers()).map(value => value: String)
    override val resourceIdentifier: Option[String] =
      scala.Option(impl.resourceIdentifier()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.databasemigration.model.CreateReplicationInstanceRequest
  ): zio.aws.databasemigration.model.CreateReplicationInstanceRequest.ReadOnly =
    new Wrapper(impl)
}
