package zio.aws.connectcases.model
import zio.aws.connectcases.model.primitives.{LayoutId, DomainId}
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class GetLayoutRequest(domainId: DomainId, layoutId: LayoutId) {
  def buildAwsValue()
      : software.amazon.awssdk.services.connectcases.model.GetLayoutRequest = {
    import GetLayoutRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.connectcases.model.GetLayoutRequest
      .builder()
      .domainId(DomainId.unwrap(domainId): java.lang.String)
      .layoutId(LayoutId.unwrap(layoutId): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.connectcases.model.GetLayoutRequest.ReadOnly =
    zio.aws.connectcases.model.GetLayoutRequest.wrap(buildAwsValue())
}
object GetLayoutRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.connectcases.model.GetLayoutRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.connectcases.model.GetLayoutRequest =
      zio.aws.connectcases.model.GetLayoutRequest(domainId, layoutId)
    def domainId: DomainId
    def layoutId: LayoutId
    def getDomainId: ZIO[Any, Nothing, DomainId] = ZIO.succeed(domainId)
    def getLayoutId: ZIO[Any, Nothing, LayoutId] = ZIO.succeed(layoutId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.connectcases.model.GetLayoutRequest
  ) extends zio.aws.connectcases.model.GetLayoutRequest.ReadOnly {
    override val domainId: DomainId =
      zio.aws.connectcases.model.primitives.DomainId(impl.domainId())
    override val layoutId: LayoutId =
      zio.aws.connectcases.model.primitives.LayoutId(impl.layoutId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.connectcases.model.GetLayoutRequest
  ): zio.aws.connectcases.model.GetLayoutRequest.ReadOnly = new Wrapper(impl)
}
