package zio.aws.connectcases.model
import zio.aws.connectcases.model.primitives.FieldValueUnionStringValueString
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class FieldValueUnion(
    booleanValue: Optional[Boolean] = Optional.Absent,
    doubleValue: Optional[Double] = Optional.Absent,
    emptyValue: Optional[zio.aws.connectcases.model.EmptyFieldValue] =
      Optional.Absent,
    stringValue: Optional[FieldValueUnionStringValueString] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.connectcases.model.FieldValueUnion = {
    import FieldValueUnion.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.connectcases.model.FieldValueUnion
      .builder()
      .optionallyWith(booleanValue.map(value => value: java.lang.Boolean))(
        _.booleanValue
      )
      .optionallyWith(doubleValue.map(value => value: java.lang.Double))(
        _.doubleValue
      )
      .optionallyWith(emptyValue.map(value => value.buildAwsValue()))(
        _.emptyValue
      )
      .optionallyWith(
        stringValue.map(value =>
          FieldValueUnionStringValueString.unwrap(value): java.lang.String
        )
      )(_.stringValue)
      .build()
  }
  def asReadOnly: zio.aws.connectcases.model.FieldValueUnion.ReadOnly =
    zio.aws.connectcases.model.FieldValueUnion.wrap(buildAwsValue())
}
object FieldValueUnion {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.connectcases.model.FieldValueUnion
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.connectcases.model.FieldValueUnion =
      zio.aws.connectcases.model.FieldValueUnion(
        booleanValue.map(value => value),
        doubleValue.map(value => value),
        emptyValue.map(value => value.asEditable),
        stringValue.map(value => value)
      )
    def booleanValue: Optional[Boolean]
    def doubleValue: Optional[Double]
    def emptyValue
        : Optional[zio.aws.connectcases.model.EmptyFieldValue.ReadOnly]
    def stringValue: Optional[FieldValueUnionStringValueString]
    def getBooleanValue: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("booleanValue", booleanValue)
    def getDoubleValue: ZIO[Any, AwsError, Double] =
      AwsError.unwrapOptionField("doubleValue", doubleValue)
    def getEmptyValue: ZIO[
      Any,
      AwsError,
      zio.aws.connectcases.model.EmptyFieldValue.ReadOnly
    ] = AwsError.unwrapOptionField("emptyValue", emptyValue)
    def getStringValue: ZIO[Any, AwsError, FieldValueUnionStringValueString] =
      AwsError.unwrapOptionField("stringValue", stringValue)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.connectcases.model.FieldValueUnion
  ) extends zio.aws.connectcases.model.FieldValueUnion.ReadOnly {
    override val booleanValue: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.booleanValue())
      .map(value => value: Boolean)
    override val doubleValue: Optional[Double] = zio.aws.core.internal
      .optionalFromNullable(impl.doubleValue())
      .map(value => value: Double)
    override val emptyValue
        : Optional[zio.aws.connectcases.model.EmptyFieldValue.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.emptyValue())
        .map(value => zio.aws.connectcases.model.EmptyFieldValue.wrap(value))
    override val stringValue: Optional[FieldValueUnionStringValueString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.stringValue())
        .map(value =>
          zio.aws.connectcases.model.primitives
            .FieldValueUnionStringValueString(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.connectcases.model.FieldValueUnion
  ): zio.aws.connectcases.model.FieldValueUnion.ReadOnly = new Wrapper(impl)
}
