package zio.aws.connectcases.model
import zio.aws.connectcases.model.primitives.FieldId
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class FieldItem(id: FieldId) {
  def buildAwsValue()
      : software.amazon.awssdk.services.connectcases.model.FieldItem = {
    import FieldItem.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.connectcases.model.FieldItem
      .builder()
      .id(FieldId.unwrap(id): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.connectcases.model.FieldItem.ReadOnly =
    zio.aws.connectcases.model.FieldItem.wrap(buildAwsValue())
}
object FieldItem {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.connectcases.model.FieldItem
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.connectcases.model.FieldItem =
      zio.aws.connectcases.model.FieldItem(id)
    def id: FieldId
    def getId: ZIO[Any, Nothing, FieldId] = ZIO.succeed(id)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.connectcases.model.FieldItem
  ) extends zio.aws.connectcases.model.FieldItem.ReadOnly {
    override val id: FieldId =
      zio.aws.connectcases.model.primitives.FieldId(impl.id())
  }
  def wrap(
      impl: software.amazon.awssdk.services.connectcases.model.FieldItem
  ): zio.aws.connectcases.model.FieldItem.ReadOnly = new Wrapper(impl)
}
