package zio.aws.connectcases.model
import zio.aws.connectcases.model.primitives.{
  TemplateId,
  DomainId,
  CreateCaseRequestClientTokenString
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class CreateCaseRequest(
    clientToken: Optional[CreateCaseRequestClientTokenString] = Optional.Absent,
    domainId: DomainId,
    fields: Iterable[zio.aws.connectcases.model.FieldValue],
    templateId: TemplateId
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.connectcases.model.CreateCaseRequest = {
    import CreateCaseRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.connectcases.model.CreateCaseRequest
      .builder()
      .optionallyWith(
        clientToken.map(value =>
          CreateCaseRequestClientTokenString.unwrap(value): java.lang.String
        )
      )(_.clientToken)
      .domainId(DomainId.unwrap(domainId): java.lang.String)
      .fields(fields.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .templateId(TemplateId.unwrap(templateId): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.connectcases.model.CreateCaseRequest.ReadOnly =
    zio.aws.connectcases.model.CreateCaseRequest.wrap(buildAwsValue())
}
object CreateCaseRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.connectcases.model.CreateCaseRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.connectcases.model.CreateCaseRequest =
      zio.aws.connectcases.model.CreateCaseRequest(
        clientToken.map(value => value),
        domainId,
        fields.map { item =>
          item.asEditable
        },
        templateId
      )
    def clientToken: Optional[CreateCaseRequestClientTokenString]
    def domainId: DomainId
    def fields: List[zio.aws.connectcases.model.FieldValue.ReadOnly]
    def templateId: TemplateId
    def getClientToken: ZIO[Any, AwsError, CreateCaseRequestClientTokenString] =
      AwsError.unwrapOptionField("clientToken", clientToken)
    def getDomainId: ZIO[Any, Nothing, DomainId] = ZIO.succeed(domainId)
    def getFields: ZIO[Any, Nothing, List[
      zio.aws.connectcases.model.FieldValue.ReadOnly
    ]] = ZIO.succeed(fields)
    def getTemplateId: ZIO[Any, Nothing, TemplateId] = ZIO.succeed(templateId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.connectcases.model.CreateCaseRequest
  ) extends zio.aws.connectcases.model.CreateCaseRequest.ReadOnly {
    override val clientToken: Optional[CreateCaseRequestClientTokenString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.clientToken())
        .map(value =>
          zio.aws.connectcases.model.primitives
            .CreateCaseRequestClientTokenString(value)
        )
    override val domainId: DomainId =
      zio.aws.connectcases.model.primitives.DomainId(impl.domainId())
    override val fields: List[zio.aws.connectcases.model.FieldValue.ReadOnly] =
      impl
        .fields()
        .asScala
        .map { item =>
          zio.aws.connectcases.model.FieldValue.wrap(item)
        }
        .toList
    override val templateId: TemplateId =
      zio.aws.connectcases.model.primitives.TemplateId(impl.templateId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.connectcases.model.CreateCaseRequest
  ): zio.aws.connectcases.model.CreateCaseRequest.ReadOnly = new Wrapper(impl)
}
