package zio.aws.connectcases.model
import zio.aws.connectcases.model.primitives.{
  ContactArn,
  ConnectedToSystemTime,
  Channel
}
import zio.ZIO
import zio.aws.core.BuilderHelper
import java.time.Instant
import scala.jdk.CollectionConverters.*
final case class ContactContent(
    channel: Channel,
    connectedToSystemTime: ConnectedToSystemTime,
    contactArn: ContactArn
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.connectcases.model.ContactContent = {
    import ContactContent.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.connectcases.model.ContactContent
      .builder()
      .channel(Channel.unwrap(channel): java.lang.String)
      .connectedToSystemTime(
        ConnectedToSystemTime.unwrap(connectedToSystemTime): Instant
      )
      .contactArn(ContactArn.unwrap(contactArn): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.connectcases.model.ContactContent.ReadOnly =
    zio.aws.connectcases.model.ContactContent.wrap(buildAwsValue())
}
object ContactContent {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.connectcases.model.ContactContent
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.connectcases.model.ContactContent =
      zio.aws.connectcases.model
        .ContactContent(channel, connectedToSystemTime, contactArn)
    def channel: Channel
    def connectedToSystemTime: ConnectedToSystemTime
    def contactArn: ContactArn
    def getChannel: ZIO[Any, Nothing, Channel] = ZIO.succeed(channel)
    def getConnectedToSystemTime: ZIO[Any, Nothing, ConnectedToSystemTime] =
      ZIO.succeed(connectedToSystemTime)
    def getContactArn: ZIO[Any, Nothing, ContactArn] = ZIO.succeed(contactArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.connectcases.model.ContactContent
  ) extends zio.aws.connectcases.model.ContactContent.ReadOnly {
    override val channel: Channel =
      zio.aws.connectcases.model.primitives.Channel(impl.channel())
    override val connectedToSystemTime: ConnectedToSystemTime =
      zio.aws.connectcases.model.primitives
        .ConnectedToSystemTime(impl.connectedToSystemTime())
    override val contactArn: ContactArn =
      zio.aws.connectcases.model.primitives.ContactArn(impl.contactArn())
  }
  def wrap(
      impl: software.amazon.awssdk.services.connectcases.model.ContactContent
  ): zio.aws.connectcases.model.ContactContent.ReadOnly = new Wrapper(impl)
}
