package zio.aws.connectcases.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class CaseFilter(
    andAll: Optional[Iterable[zio.aws.connectcases.model.CaseFilter]] =
      Optional.Absent,
    field: Optional[zio.aws.connectcases.model.FieldFilter] = Optional.Absent,
    not: Optional[zio.aws.connectcases.model.CaseFilter] = Optional.Absent,
    orAll: Optional[Iterable[zio.aws.connectcases.model.CaseFilter]] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.connectcases.model.CaseFilter = {
    import CaseFilter.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.connectcases.model.CaseFilter
      .builder()
      .optionallyWith(
        andAll.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.andAll)
      .optionallyWith(field.map(value => value.buildAwsValue()))(_.field)
      .optionallyWith(not.map(value => value.buildAwsValue()))(_.not)
      .optionallyWith(
        orAll.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.orAll)
      .build()
  }
  def asReadOnly: zio.aws.connectcases.model.CaseFilter.ReadOnly =
    zio.aws.connectcases.model.CaseFilter.wrap(buildAwsValue())
}
object CaseFilter {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.connectcases.model.CaseFilter
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.connectcases.model.CaseFilter =
      zio.aws.connectcases.model.CaseFilter(
        andAll.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        field.map(value => value.asEditable),
        not.map(value => value.asEditable),
        orAll.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def andAll: Optional[List[zio.aws.connectcases.model.CaseFilter.ReadOnly]]
    def field: Optional[zio.aws.connectcases.model.FieldFilter.ReadOnly]
    def not: Optional[zio.aws.connectcases.model.CaseFilter.ReadOnly]
    def orAll: Optional[List[zio.aws.connectcases.model.CaseFilter.ReadOnly]]
    def getAndAll: ZIO[Any, AwsError, List[
      zio.aws.connectcases.model.CaseFilter.ReadOnly
    ]] = AwsError.unwrapOptionField("andAll", andAll)
    def getField
        : ZIO[Any, AwsError, zio.aws.connectcases.model.FieldFilter.ReadOnly] =
      AwsError.unwrapOptionField("field", field)
    def getNot
        : ZIO[Any, AwsError, zio.aws.connectcases.model.CaseFilter.ReadOnly] =
      AwsError.unwrapOptionField("not", not)
    def getOrAll: ZIO[Any, AwsError, List[
      zio.aws.connectcases.model.CaseFilter.ReadOnly
    ]] = AwsError.unwrapOptionField("orAll", orAll)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.connectcases.model.CaseFilter
  ) extends zio.aws.connectcases.model.CaseFilter.ReadOnly {
    override val andAll
        : Optional[List[zio.aws.connectcases.model.CaseFilter.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.andAll())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.connectcases.model.CaseFilter.wrap(item)
          }.toList
        )
    override val field
        : Optional[zio.aws.connectcases.model.FieldFilter.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.field())
        .map(value => zio.aws.connectcases.model.FieldFilter.wrap(value))
    override val not: Optional[zio.aws.connectcases.model.CaseFilter.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.not())
        .map(value => zio.aws.connectcases.model.CaseFilter.wrap(value))
    override val orAll
        : Optional[List[zio.aws.connectcases.model.CaseFilter.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.orAll())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.connectcases.model.CaseFilter.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.connectcases.model.CaseFilter
  ): zio.aws.connectcases.model.CaseFilter.ReadOnly = new Wrapper(impl)
}
