package zio.aws.connectcases.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class BatchPutFieldOptionsResponse(
    errors: Optional[Iterable[zio.aws.connectcases.model.FieldOptionError]] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.connectcases.model.BatchPutFieldOptionsResponse = {
    import BatchPutFieldOptionsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.connectcases.model.BatchPutFieldOptionsResponse
      .builder()
      .optionallyWith(
        errors.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.errors)
      .build()
  }
  def asReadOnly
      : zio.aws.connectcases.model.BatchPutFieldOptionsResponse.ReadOnly =
    zio.aws.connectcases.model.BatchPutFieldOptionsResponse
      .wrap(buildAwsValue())
}
object BatchPutFieldOptionsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.connectcases.model.BatchPutFieldOptionsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.connectcases.model.BatchPutFieldOptionsResponse =
      zio.aws.connectcases.model.BatchPutFieldOptionsResponse(
        errors.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def errors
        : Optional[List[zio.aws.connectcases.model.FieldOptionError.ReadOnly]]
    def getErrors: ZIO[Any, AwsError, List[
      zio.aws.connectcases.model.FieldOptionError.ReadOnly
    ]] = AwsError.unwrapOptionField("errors", errors)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.connectcases.model.BatchPutFieldOptionsResponse
  ) extends zio.aws.connectcases.model.BatchPutFieldOptionsResponse.ReadOnly {
    override val errors
        : Optional[List[zio.aws.connectcases.model.FieldOptionError.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.errors())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.connectcases.model.FieldOptionError.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.connectcases.model.BatchPutFieldOptionsResponse
  ): zio.aws.connectcases.model.BatchPutFieldOptionsResponse.ReadOnly =
    new Wrapper(impl)
}
