package zio.aws.connectcases.model
import zio.aws.connectcases.model.primitives.NextToken
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class ListTemplatesResponse(
    nextToken: Optional[NextToken] = Optional.Absent,
    templates: Iterable[zio.aws.connectcases.model.TemplateSummary]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.connectcases.model.ListTemplatesResponse = {
    import ListTemplatesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.connectcases.model.ListTemplatesResponse
      .builder()
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .templates(templates.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .build()
  }
  def asReadOnly: zio.aws.connectcases.model.ListTemplatesResponse.ReadOnly =
    zio.aws.connectcases.model.ListTemplatesResponse.wrap(buildAwsValue())
}
object ListTemplatesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.connectcases.model.ListTemplatesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.connectcases.model.ListTemplatesResponse =
      zio.aws.connectcases.model.ListTemplatesResponse(
        nextToken.map(value => value),
        templates.map { item =>
          item.asEditable
        }
      )
    def nextToken: Optional[NextToken]
    def templates: List[zio.aws.connectcases.model.TemplateSummary.ReadOnly]
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getTemplates: ZIO[Any, Nothing, List[
      zio.aws.connectcases.model.TemplateSummary.ReadOnly
    ]] = ZIO.succeed(templates)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.connectcases.model.ListTemplatesResponse
  ) extends zio.aws.connectcases.model.ListTemplatesResponse.ReadOnly {
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.connectcases.model.primitives.NextToken(value))
    override val templates
        : List[zio.aws.connectcases.model.TemplateSummary.ReadOnly] = impl
      .templates()
      .asScala
      .map { item =>
        zio.aws.connectcases.model.TemplateSummary.wrap(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.connectcases.model.ListTemplatesResponse
  ): zio.aws.connectcases.model.ListTemplatesResponse.ReadOnly = new Wrapper(
    impl
  )
}
