package zio.aws.connectcases.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class LayoutContent(
    basic: Optional[zio.aws.connectcases.model.BasicLayout] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.connectcases.model.LayoutContent = {
    import LayoutContent.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.connectcases.model.LayoutContent
      .builder()
      .optionallyWith(basic.map(value => value.buildAwsValue()))(_.basic)
      .build()
  }
  def asReadOnly: zio.aws.connectcases.model.LayoutContent.ReadOnly =
    zio.aws.connectcases.model.LayoutContent.wrap(buildAwsValue())
}
object LayoutContent {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.connectcases.model.LayoutContent
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.connectcases.model.LayoutContent =
      zio.aws.connectcases.model
        .LayoutContent(basic.map(value => value.asEditable))
    def basic: Optional[zio.aws.connectcases.model.BasicLayout.ReadOnly]
    def getBasic
        : ZIO[Any, AwsError, zio.aws.connectcases.model.BasicLayout.ReadOnly] =
      AwsError.unwrapOptionField("basic", basic)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.connectcases.model.LayoutContent
  ) extends zio.aws.connectcases.model.LayoutContent.ReadOnly {
    override val basic
        : Optional[zio.aws.connectcases.model.BasicLayout.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.basic())
        .map(value => zio.aws.connectcases.model.BasicLayout.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.connectcases.model.LayoutContent
  ): zio.aws.connectcases.model.LayoutContent.ReadOnly = new Wrapper(impl)
}
