package zio.aws.connectcases.model
import zio.aws.connectcases.model.primitives.{FieldName, FieldId, FieldArn}
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class FieldSummary(
    fieldArn: FieldArn,
    fieldId: FieldId,
    name: FieldName,
    namespace: zio.aws.connectcases.model.FieldNamespace,
    `type`: zio.aws.connectcases.model.FieldType
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.connectcases.model.FieldSummary = {
    import FieldSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.connectcases.model.FieldSummary
      .builder()
      .fieldArn(FieldArn.unwrap(fieldArn): java.lang.String)
      .fieldId(FieldId.unwrap(fieldId): java.lang.String)
      .name(FieldName.unwrap(name): java.lang.String)
      .namespace(namespace.unwrap)
      .`type`(`type`.unwrap)
      .build()
  }
  def asReadOnly: zio.aws.connectcases.model.FieldSummary.ReadOnly =
    zio.aws.connectcases.model.FieldSummary.wrap(buildAwsValue())
}
object FieldSummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.connectcases.model.FieldSummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.connectcases.model.FieldSummary =
      zio.aws.connectcases.model.FieldSummary(
        fieldArn,
        fieldId,
        name,
        namespace,
        `type`
      )
    def fieldArn: FieldArn
    def fieldId: FieldId
    def name: FieldName
    def namespace: zio.aws.connectcases.model.FieldNamespace
    def `type`: zio.aws.connectcases.model.FieldType
    def getFieldArn: ZIO[Any, Nothing, FieldArn] = ZIO.succeed(fieldArn)
    def getFieldId: ZIO[Any, Nothing, FieldId] = ZIO.succeed(fieldId)
    def getName: ZIO[Any, Nothing, FieldName] = ZIO.succeed(name)
    def getNamespace
        : ZIO[Any, Nothing, zio.aws.connectcases.model.FieldNamespace] =
      ZIO.succeed(namespace)
    def getType: ZIO[Any, Nothing, zio.aws.connectcases.model.FieldType] =
      ZIO.succeed(`type`)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.connectcases.model.FieldSummary
  ) extends zio.aws.connectcases.model.FieldSummary.ReadOnly {
    override val fieldArn: FieldArn =
      zio.aws.connectcases.model.primitives.FieldArn(impl.fieldArn())
    override val fieldId: FieldId =
      zio.aws.connectcases.model.primitives.FieldId(impl.fieldId())
    override val name: FieldName =
      zio.aws.connectcases.model.primitives.FieldName(impl.name())
    override val namespace: zio.aws.connectcases.model.FieldNamespace =
      zio.aws.connectcases.model.FieldNamespace.wrap(impl.namespace())
    override val `type`: zio.aws.connectcases.model.FieldType =
      zio.aws.connectcases.model.FieldType.wrap(impl.`type`())
  }
  def wrap(
      impl: software.amazon.awssdk.services.connectcases.model.FieldSummary
  ): zio.aws.connectcases.model.FieldSummary.ReadOnly = new Wrapper(impl)
}
